/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.async;

import com.xunlei.netty.httpserver.async.AsyncProxyHandler;
import com.xunlei.util.Log;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;

public class AsyncProxyPooledHandler
extends AsyncProxyHandler {
    private static final Logger log = Log.getLogger();
    private final Map<SocketAddress, ConcurrentLinkedQueue<Channel>> channelPool = new ConcurrentHashMap<SocketAddress, ConcurrentLinkedQueue<Channel>>();

    public AsyncProxyPooledHandler(ClientBootstrap backstageClientBootstrap) {
        super(backstageClientBootstrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Channel getChannel(SocketAddress backstageHostAddress) {
        ConcurrentLinkedQueue<Channel> queue = null;
        String string = backstageHostAddress.toString().intern();
        synchronized (string) {
            queue = this.channelPool.get(backstageHostAddress);
            if (queue == null) {
                queue = new ConcurrentLinkedQueue();
                this.channelPool.put(backstageHostAddress, queue);
            }
        }
        Channel c = queue.poll();
        if (c == null) {
            log.debug("channelPoll hasn't any available channel,creat one![{}]", backstageHostAddress);
            return this.newChannel(backstageHostAddress);
        }
        if (!c.isConnected()) {
            log.debug("channelPoll has one unavailable channel:{},creat another!", c);
            this.channelAttachMap.remove(c);
            return this.newChannel(backstageHostAddress);
        }
        log.debug("channelPoll has one available channel:{}", c);
        return c;
    }

    @Override
    protected void messageReceivedFinally(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Channel c = ctx.getChannel();
        SocketAddress backstageHostAddress = c.getRemoteAddress();
        ConcurrentLinkedQueue<Channel> queue = this.channelPool.get(backstageHostAddress);
        if (queue != null) {
            queue.offer(c);
        }
    }

    public Map<SocketAddress, ConcurrentLinkedQueue<Channel>> getChannelPool() {
        return this.channelPool;
    }
}

