/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.httptool.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Pager {
    private int pageSize;

    public static void main(String[] args) {
        ArrayList<Integer> a = new ArrayList<Integer>();
        int i = 0;
        while (i < 999) {
            a.add(i);
            ++i;
        }
        Pager p = new Pager(8);
        System.out.println("\u5012\u5e8f");
        for (Integer i2 : p.getPageDesc(1, a)) {
            System.out.print(i2 + " ");
        }
        System.out.println();
        for (Integer i2 : p.getPageDesc(2, a)) {
            System.out.print(i2 + " ");
        }
        System.out.println();
        for (Integer i2 : p.getPageDesc(125, a)) {
            System.out.print(i2 + " ");
        }
        System.out.println();
        System.out.println("\u987a\u5e8f");
        for (Integer i2 : p.getPage(1, a)) {
            System.out.print(i2 + " ");
        }
        System.out.println();
        for (Integer i2 : p.getPage(2, a)) {
            System.out.print(i2 + " ");
        }
        System.out.println();
        for (Integer i2 : p.getPage(3, a)) {
            System.out.print(i2 + " ");
        }
        System.out.println();
        for (Integer i2 : p.getPage(125, a)) {
            System.out.print(i2 + " ");
        }
        System.out.println();
        System.out.println("totalPage:" + p.getTotalPage(a));
    }

    public Pager(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize must be positive:" + pageSize);
        }
    }

    public <T> List<T> getPage(int pageNo, Collection<T> list) {
        if (pageNo <= 0) {
            throw new IllegalArgumentException("pageNo must be positive:" + pageNo);
        }
        return this.getPage(pageNo, list, false);
    }

    public <T> List<T> getPage(int pageNo, Collection<T> list, boolean desc) {
        if (pageNo <= 0) {
            throw new IllegalArgumentException("pageNo must be positive:" + pageNo);
        }
        int start = (pageNo - 1) * this.pageSize;
        int end = start + this.pageSize;
        int totalCount = this.getTotalCount(list);
        if (end > totalCount) {
            end = totalCount;
        }
        if (start > end) {
            return Collections.EMPTY_LIST;
        }
        boolean isList = list instanceof List;
        int realSize = end - start;
        ArrayList<Object> pagerList = new ArrayList<Object>(realSize);
        if (desc) {
            end = totalCount - end;
            start = totalCount - start - 1;
            if (isList) {
                int i = start;
                while (i >= end) {
                    pagerList.add(((List)list).get(i));
                    --i;
                }
            } else {
                Iterator<T> iter = list.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    T item = iter.next();
                    if (i >= end) {
                        if (i > start) break;
                        pagerList.add(item);
                    }
                    ++i;
                }
                Collections.reverse(pagerList);
            }
        } else if (isList) {
            int i = start;
            while (i < end) {
                pagerList.add(((List)list).get(i));
                ++i;
            }
        } else {
            Iterator<T> iter = list.iterator();
            int i = 0;
            while (iter.hasNext()) {
                T item = iter.next();
                if (i >= start) {
                    if (i >= end) break;
                    pagerList.add(item);
                }
                ++i;
            }
        }
        return pagerList;
    }

    public <T> List<T> getPage(int pageNo, T[] array) {
        if (pageNo <= 0) {
            throw new IllegalArgumentException("pageNo must be positive:" + pageNo);
        }
        return this.getPage(pageNo, array, false);
    }

    public <T> List<T> getPage(int pageNo, T[] array, boolean desc) {
        if (pageNo <= 0) {
            throw new IllegalArgumentException("pageNo must be positive:" + pageNo);
        }
        int start = (pageNo - 1) * this.pageSize;
        int end = start + this.pageSize;
        int totalCount = this.getTotalCount(array);
        if (end > totalCount) {
            end = totalCount;
        }
        if (start > end) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> pagerList = new ArrayList<T>(end - start);
        if (desc) {
            end = totalCount - end;
            int i = start = totalCount - start - 1;
            while (i >= end) {
                pagerList.add(array[i]);
                --i;
            }
        } else {
            int i = start;
            while (i < end) {
                pagerList.add(array[i]);
                ++i;
            }
        }
        return pagerList;
    }

    public <T> List<T> getPageDesc(int pageNo, Collection<T> list) {
        if (pageNo <= 0) {
            throw new IllegalArgumentException("pageNo must be positive:" + pageNo);
        }
        return this.getPage(pageNo, list, true);
    }

    public <T> List<T> getPageDesc(int pageNo, T[] array) {
        if (pageNo <= 0) {
            throw new IllegalArgumentException("pageNo must be positive:" + pageNo);
        }
        return this.getPage(pageNo, array, true);
    }

    public int getTotalCount(Collection<?> list) {
        return list.size();
    }

    public int getTotalCount(Object[] array) {
        return array.length;
    }

    public int getTotalPage(int totalCount) {
        if (totalCount == 0) {
            return 1;
        }
        int r = totalCount / this.pageSize;
        return totalCount % this.pageSize > 0 ? r + 1 : r;
    }

    public int getTotalPage(Collection<?> list) {
        return this.getTotalPage(this.getTotalCount(list));
    }

    public int getTotalPage(Object[] array) {
        return this.getTotalPage(this.getTotalCount(array));
    }

    public int getStartIndex(int pageNo) {
        if (pageNo <= 0) {
            throw new IllegalArgumentException("pageNo must be positive:" + pageNo);
        }
        return (pageNo - 1) * this.pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

