/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.ImagesHandle;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.LibConfig;
import com.xunlei.common.web.model.FileNameHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.log4j.Logger;

public class UploadFileServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(UploadFileServlet.class);
    private static final String saveRootPath = ApplicationConfigUtil.getRootFilePath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().write("<script type='text/javascript'>alert('not allow get method!')</script>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String rs = "";
        FileNameHandle fnh = null;
        request.setCharacterEncoding("UTF-8");
        String savepath = StringTools.escapeSql(request.getParameter("savepath"));
        String savename = StringTools.escapeSql(request.getParameter("savename"));
        String filemsg = StringTools.escapeSql(request.getParameter("filemsg"));
        if (StringTools.isNotEmpty(filemsg)) {
            filemsg = new String(filemsg.getBytes("iso-8859-1"), "UTF-8");
        }
        try {
            FileItem fi;
            HttpSession session = request.getSession();
            if (StringTools.isEmpty(savepath)) {
                savepath = (String)session.getAttribute("savepath");
                session.removeAttribute("savepath");
            }
            if (StringTools.isEmpty(savename)) {
                savename = (String)session.getAttribute("savename");
                session.removeAttribute("savename");
            }
            logger.debug("\u6587\u4ef6\u4fdd\u5b58\u76f8\u5bf9\u8def\u5f84\uff1a" + savepath);
            FileUpload fu = new FileUpload();
            fu.setHeaderEncoding(request.getCharacterEncoding());
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setRepository(new File(System.getProperty("java.io.tmpdir", "temp")));
            factory.setSizeThreshold(0xF00000);
            fu.setFileItemFactory(factory);
            fu.setFileSizeMax(0x3200000L);
            List fileItems = fu.parseRequest(new ServletRequestContext(request));
            int fileCount = 0;
            for (Object obj : fileItems) {
                fi = (FileItem)obj;
                if (fi.isFormField() || fi.getSize() <= 0L) continue;
                ++fileCount;
            }
            fnh = new FileNameHandle(savename, filemsg, fileCount);
            for (Object obj : fileItems) {
                try {
                    fi = (FileItem)obj;
                    if (fi.isFormField() || fi.getSize() == 0L) continue;
                    String name = fi.getName();
                    String ext = name.substring(name.lastIndexOf(".") + 1, name.length()).toLowerCase();
                    String currentSaveName = fnh.getFileName(name);
                    fnh.setCurrentExt(ext);
                    String saveFullName = currentSaveName + "." + ext;
                    String allowexts = LibConfig.getValue("AllowFiles").toLowerCase();
                    long filesize = StringTools.safeToLong(LibConfig.getValue("MaxFileSize")) * 1024L;
                    if (filesize > 0L && filesize < fi.getSize()) {
                        logger.debug("\u6587\u4ef6\u957f\u5ea6\u8d85\u8fc7\u6240\u89c4\u5b9a\u7684\u957f\u5ea6");
                        rs = "\u6587\u4ef6\u957f\u5ea6\u8d85\u8fc7\u6240\u89c4\u5b9a\u7684\u957f\u5ea6";
                        continue;
                    }
                    if (StringTools.isNotEmpty(allowexts)) {
                        String[] allowextArray = allowexts.toLowerCase().split("\\|");
                        if (StringTools.isContainsString(ext, allowextArray)) {
                            String saveFullpath = saveRootPath + savepath;
                            logger.debug("\u6587\u4ef6\u4fdd\u5b58\u5b8c\u6574\u8def\u5f84\uff1a" + saveFullpath + saveFullName);
                            InputStream in = fi.getInputStream();
                            if (!new File(saveFullpath).isDirectory()) {
                                new File(saveFullpath).mkdirs();
                            }
                            FileOutputStream out = new FileOutputStream(saveFullpath + saveFullName);
                            try {
                                long fSize = fi.getSize();
                                byte[] buffer = new byte[(int)fSize];
                                in.read(buffer, 0, (int)fSize);
                                ((OutputStream)out).write(buffer, 0, (int)fSize);
                                fnh.setCurrentUploadSuccess(true);
                                rs = "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f";
                                if (fnh.getCurrentWidth() <= 0 || fnh.getCurrentHeight() <= 0) continue;
                                ImagesHandle.saveImageAsJpg(saveFullpath + saveFullName, saveFullpath + "b_" + saveFullName, fnh.getCurrentWidth(), fnh.getCurrentHeight(), false);
                                continue;
                            }
                            catch (Exception ex) {
                                logger.error("\u4fdd\u5b58\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff1a" + ex);
                                rs = "\u4fdd\u5b58\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38";
                                continue;
                            }
                            finally {
                                in.close();
                                ((OutputStream)out).close();
                                continue;
                            }
                        }
                        logger.debug("\u6587\u4ef6\u6269\u5c55\u540d" + ext + "\u4e0d\u7b26\u5408\u8981\u6c42\u3002");
                        rs = "\u6587\u4ef6\u6269\u5c55\u540d" + ext + "\u4e0d\u7b26\u5408\u8981\u6c42";
                        continue;
                    }
                    logger.debug("\u8bf7\u8bbe\u7f6eAllowFiles\u53c2\u6570\u4e3a\u53ef\u7528\u7684\u6587\u4ef6\u6269\u5c55\u540d\uff0c\u5982jpeg|jpg|txt|rar");
                }
                catch (Exception ex) {
                    logger.error(ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex);
            rs = StringTools.escapeHtml("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        String str = "<script type='text/javascript'>parent.uploadFileFinish('" + (fnh == null ? "false" : fnh.toSuccessString()) + "','" + StringTools.encodeURL(rs) + "','" + (fnh == null ? "" : fnh.toSaveFileNameString(StringTools.isNotEmpty(filemsg))) + "');</script>";
        response.getWriter().write(str);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

