/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.Validator;
import com.xunlei.common.vo.MailPrevAndNext;
import com.xunlei.common.vo.Mailclass;
import com.xunlei.common.vo.MailcountInfo;
import com.xunlei.common.vo.Mailinfo;
import com.xunlei.common.vo.Mailsendtemp;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FunRef(value="Mail")
public class MailManagedBean
extends AbstractManagedBean {
    private static final String SPLIT = ",";
    private Sheet<Mailsendtemp> mailsendtempsheet = null;

    public Map<String, String> getMailclassMap() {
        HashMap<String, String> mailclassMap = (HashMap<String, String>)this.getRequestAttribute("mailclassMap");
        if (mailclassMap == null) {
            mailclassMap = new HashMap<String, String>();
            List<Mailclass> mailList = commfacade.queryMailclass(new Mailclass());
            if (mailList != null && mailList.size() > 0) {
                for (Mailclass m : mailList) {
                    mailclassMap.put(m.getClassid(), m.getClassname());
                }
            }
            this.setRequestAttribute("mailclassMap", mailclassMap);
        }
        return mailclassMap;
    }

    public SelectItem[] getMyclasslist() {
        String[] usermailclass = this.currentUserInfo().getMailclassids();
        if (usermailclass == null) {
            return new SelectItem[]{new SelectItem((Object)"", "")};
        }
        Map<String, String> map = this.getMailclassMap();
        SelectItem[] items = new SelectItem[usermailclass.length + 1];
        items[0] = new SelectItem((Object)"", "");
        int index = 0;
        for (int i = 0; i < usermailclass.length; ++i) {
            items[++index] = new SelectItem((Object)usermailclass[i], map.get(usermailclass[i]));
        }
        return items;
    }

    public SelectItem[] getClasslist() {
        Map<String, String> map = this.getMailclassMap();
        SelectItem[] items = new SelectItem[map.size() + 1];
        items[0] = new SelectItem((Object)"", "");
        int index = 0;
        for (Map.Entry<String, String> enty : map.entrySet()) {
            items[++index] = new SelectItem((Object)enty.getKey(), enty.getValue());
        }
        return items;
    }

    public SelectItem[] getFrontuserlist() {
        String[] frontusers = commfacade.getFrontUsersLognoAndTrueName();
        if (frontusers == null) {
            frontusers = new String[]{};
        }
        SelectItem[] items = new SelectItem[frontusers.length];
        for (int i = 0; i < frontusers.length; ++i) {
            String[] kv = frontusers[i].split("\\|");
            items[i] = new SelectItem((Object)kv[0], kv[0] + "--" + (kv.length > 1 ? kv[1] : ""));
            items[i].setEscape(false);
        }
        return items;
    }

    public String goReply() {
        Mailinfo query = this.findBean(Mailinfo.class);
        Mailinfo querymail = new Mailinfo();
        querymail.setSeqid(query.getSeqid());
        querymail.setMaildirection((short)2);
        HttpSession session = this.getHttpServletRequest().getSession();
        session.setAttribute("maileditfrom", "input");
        Mailinfo mailinfo = commfacade.getMailinfo(querymail);
        mailinfo.setType("reply");
        mailinfo.setTitle("RE:" + mailinfo.getTitle());
        mailinfo.setContent(mailinfo.getReplybody());
        mailinfo.setReceiver(mailinfo.getSender());
        this.mergeBean(mailinfo);
        return "go_reply";
    }

    public String save() {
        Mailinfo mailinfo = this.findBean(Mailinfo.class);
        mailinfo.setSender(mailinfo.getClassid());
        mailinfo.setInputby(this.currentUserLogo());
        if (!Validator.isAllNotEmpty(mailinfo.getTitle(), mailinfo.getClassid(), mailinfo.getContent())) {
            this.alertJS("\u8bf7\u8f93\u5165\u5b8c\u6574\u7684\u6570\u636e\uff01");
        }
        if (mailinfo.getTitle().length() > 255) {
            mailinfo.setTitle(mailinfo.getTitle().substring(0, 255));
        }
        commfacade.doSendMail(mailinfo);
        boolean isReply = "reply".equalsIgnoreCase(mailinfo.getType());
        if (isReply) {
            return "go_replysuccess";
        }
        return "go_sendsuccess";
    }

    public String getQuerySendmaillist() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Mailinfo querymail = new Mailinfo();
        String[] usermailclassid = this.currentUserInfo().getMailclassids();
        querymail.setSenderclassids(usermailclassid);
        querymail.setQuerysenderdeltype(-1);
        querymail.setMaildirection((short)1);
        Sheet<Mailinfo> sheet = commfacade.queryMailinfo(querymail, fliper);
        this.mergePagedDataModel(sheet, fliper);
        this.querySendtemp();
        return "";
    }

    public String getQueryInputmaillist() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Mailinfo querymail = new Mailinfo();
        String[] usermailclassid = this.currentUserInfo().getMailclassids();
        querymail.setReceiverclassids(usermailclassid);
        querymail.setQueryreceiverdeltype(-1);
        querymail.setMaildirection((short)2);
        Sheet<Mailinfo> sheet = commfacade.queryMailinfo(querymail, fliper);
        this.mergePagedDataModel(sheet, fliper);
        return "";
    }

    public boolean getHasSendingmail() {
        return this.querySendtemp();
    }

    public String getMaildetail() {
        Mailinfo querymail = this.findBean(Mailinfo.class);
        boolean isSendbox = "sendbox".equalsIgnoreCase(querymail.getType());
        String[] usermailclassid = this.currentUserInfo().getMailclassids();
        if (isSendbox) {
            querymail.setSenderclassids(usermailclassid);
            querymail.setQuerysenderdeltype(-1);
        } else {
            querymail.setReceiverclassids(usermailclassid);
            querymail.setQueryreceiverdeltype(-1);
        }
        Mailinfo mail = commfacade.getMailinfo(querymail);
        if (!isSendbox && mail.getReaded() == 0) {
            mail.setReaded((short)1);
            commfacade.updateMailinfo(mail);
        }
        if (mail != null) {
            MailPrevAndNext mailPNN = commfacade.getMailPrevAndNextSeqid(querymail);
            this.mergeBean((Object)mailPNN, "mailPrevAndNext");
            mail.setType(querymail.getType());
        }
        this.mergeBean(mail);
        return "";
    }

    public String detailGoBack() {
        Mailinfo queryMail = this.findBean(Mailinfo.class);
        if ("sendbox".equals(queryMail.getType())) {
            return "go_sendmailbox";
        }
        return "go_inputmailbox";
    }

    public String delete() {
        Mailinfo queryMail = this.findBean(Mailinfo.class);
        MailPrevAndNext mpan = this.findBean(MailPrevAndNext.class, "mailPrevAndNext");
        boolean isSendbox = "sendbox".equalsIgnoreCase(queryMail.getType());
        Mailinfo deleteMail = new Mailinfo();
        String[] usermailclassid = this.currentUserInfo().getMailclassids();
        deleteMail.setSeqid(queryMail.getSeqid());
        if (isSendbox) {
            deleteMail.setSenderclassids(usermailclassid);
        } else {
            deleteMail.setReceiverclassids(usermailclassid);
        }
        Mailinfo delete = commfacade.getMailinfo(queryMail);
        if (delete != null) {
            if (!isSendbox) {
                delete.setReceiverdel((short)1);
                delete.setReceiverdeltime(DatetimeUtil.now());
            } else {
                delete.setSenderdel((short)1);
                delete.setSenderdeltime(DatetimeUtil.now());
            }
            commfacade.updateMailinfo(delete);
        }
        if (mpan.getNextseqid() > 0L) {
            deleteMail.setType(queryMail.getType());
            deleteMail.setSeqid(mpan.getNextseqid());
            this.mergeBean(deleteMail);
            return "";
        }
        if (isSendbox) {
            return "go_sendmailbox";
        }
        return "go_inputmailbox";
    }

    public String setUnread() {
        String[] usermailclassid = this.currentUserInfo().getMailclassids();
        long[] seqids = this.findParamSeqids();
        Mailinfo queryMail = new Mailinfo();
        queryMail.setReceiverclassids(usermailclassid);
        for (long seqid : seqids) {
            queryMail.setSeqid(seqid);
            Mailinfo unreadmail = commfacade.getMailinfo(queryMail);
            if (unreadmail == null) continue;
            unreadmail.setReaded((short)0);
            commfacade.updateMailinfo(unreadmail);
        }
        this.getQueryInputmaillist();
        return "";
    }

    public String setReaded() {
        String[] usermailclassid = this.currentUserInfo().getMailclassids();
        long[] seqids = this.findParamSeqids();
        Mailinfo queryMail = new Mailinfo();
        queryMail.setReceiverclassids(usermailclassid);
        for (long seqid : seqids) {
            queryMail.setSeqid(seqid);
            Mailinfo unreadmail = commfacade.getMailinfo(queryMail);
            if (unreadmail == null) continue;
            unreadmail.setReaded((short)1);
            commfacade.updateMailinfo(unreadmail);
        }
        this.getQueryInputmaillist();
        return "";
    }

    public String getInitEdit() {
        String from = this.findParameter("from");
        HttpSession session = this.getHttpServletRequest().getSession();
        if ("input".equalsIgnoreCase(from)) {
            session.setAttribute("maileditfrom", "input");
        } else if ("sendbox".equalsIgnoreCase(from)) {
            session.setAttribute("maileditfrom", "sendbox");
        }
        return "";
    }

    public String deleteSome() {
        Mailinfo typemail = this.findBean(Mailinfo.class);
        boolean isSendbox = "sendbox".equalsIgnoreCase(typemail.getType());
        String[] usermailclassid = this.currentUserInfo().getMailclassids();
        long[] seqids = this.findParamSeqids();
        Mailinfo queryMail = new Mailinfo();
        if (isSendbox) {
            queryMail.setSenderclassids(usermailclassid);
        } else {
            queryMail.setReceiverclassids(usermailclassid);
        }
        for (long seqid : seqids) {
            queryMail.setSeqid(seqid);
            Mailinfo deletemail = commfacade.getMailinfo(queryMail);
            if (deletemail == null) continue;
            if (!isSendbox) {
                deletemail.setReceiverdel((short)1);
                deletemail.setReceiverdeltime(DatetimeUtil.now());
            } else {
                deletemail.setSenderdel((short)1);
                deletemail.setSenderdeltime(DatetimeUtil.now());
            }
            commfacade.updateMailinfo(deletemail);
        }
        if (isSendbox) {
            this.getQuerySendmaillist();
        } else {
            this.getQueryInputmaillist();
        }
        return "";
    }

    public String resendTemp() {
        String allsendno = this.findParameter("allsendno");
        commfacade.doResendTemp(allsendno);
        this.querySendtemp();
        return "";
    }

    private boolean querySendtemp() {
        boolean res = true;
        PagedFliper fliper2 = this.getFliper(2);
        if (this.mailsendtempsheet == null) {
            Mailsendtemp temp = new Mailsendtemp();
            temp.setInputby(this.currentUserLogo());
            this.mailsendtempsheet = commfacade.queryMailsendtemp(temp, fliper2);
        }
        if (this.mailsendtempsheet.getRowcount() <= 0) {
            res = false;
        }
        this.mergePagedDataModel(this.mailsendtempsheet, fliper2);
        return res;
    }

    public String getMailcount() {
        String[] usermailclassid = this.currentUserInfo().getMailclassids();
        MailcountInfo mc = commfacade.getClassMailinfocount(usermailclassid);
        String html = mc.getUnread() > 0 ? "[<b style='color:red'>" + mc.getUnread() + "</b>/" + mc.getTotal() + "]" : "[0/" + mc.getTotal() + "]";
        return html;
    }

    public String stub() {
        return "";
    }

    public String getAdminquery() {
        this.authenticateRun();
        Mailinfo mailinfo = this.findBean(Mailinfo.class);
        if (this.isEmpty(mailinfo.getFromdate())) {
            mailinfo.setFromdate(DatetimeUtil.dateofSepcial(-10));
        }
        if (this.isEmpty(mailinfo.getTodate())) {
            mailinfo.setTodate(DatetimeUtil.today());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Sheet<Mailinfo> sheet = commfacade.queryMailinfo(mailinfo, fliper);
        this.mergePagedDataModel(sheet, fliper);
        return "";
    }

    public String adminDelete() {
        this.authenticateDel();
        long[] seqids = this.findParamSeqids();
        if (seqids != null) {
            for (long seqid : seqids) {
                commfacade.deleteMailinfoById(seqid);
            }
        }
        this.getAdminquery();
        return "";
    }

    public String adminMaildetail() {
        Mailinfo m;
        this.authenticateRun();
        long seqid = this.findParamLong("detailseqid");
        if (seqid > 0L && (m = commfacade.getMailinfoById(seqid)) != null) {
            this.mergeBean((Object)m, "mailinfo2");
        }
        return "";
    }
}

