/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.OnlineUserInfo;
import com.xunlei.common.web.model.FunctionManagedBean;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoginUserContainer
implements Serializable {
    private static Logger logger = Logger.getLogger(FunctionManagedBean.class);
    Map<String, OnlineUserInfo> loginUsersMap = new HashMap<String, OnlineUserInfo>();

    public LoginUserContainer() {
        logger.debug("LoginUserContainer init");
    }

    public int getTotalUsers() {
        return this.loginUsersMap.size();
    }

    public void addUser(String username, String sessionid, String ip, boolean singlelogin) {
        if (StringTools.isEmpty(username)) {
            return;
        }
        OnlineUserInfo onlineUserInfo = this.loginUsersMap.get(username);
        if (onlineUserInfo == null || singlelogin) {
            OnlineUserInfo newOnlineUserInfo = new OnlineUserInfo();
            logger.debug("\u65b0\u589e\u7528\u6237\uff1a" + username + ",sessionid\uff1a" + sessionid + ",singlelogin:" + singlelogin);
            newOnlineUserInfo.setUsername(username);
            newOnlineUserInfo.setSessionid(sessionid);
            newOnlineUserInfo.setSinglelogin(singlelogin);
            newOnlineUserInfo.refreshTime();
            newOnlineUserInfo.increateCount();
            newOnlineUserInfo.putIpMap(sessionid, ip);
            this.loginUsersMap.put(username, newOnlineUserInfo);
        } else {
            logger.debug("\u7528\u6237\uff1a" + username + "\uff0c\u65b0sessionid:" + sessionid + "\u66ff\u6362\u65e7sessionid:" + onlineUserInfo.getSessionid());
            onlineUserInfo.setSessionid(sessionid);
            onlineUserInfo.setSinglelogin(singlelogin);
            onlineUserInfo.refreshTime();
            onlineUserInfo.increateCount();
            onlineUserInfo.putIpMap(sessionid, ip);
            this.loginUsersMap.put(username, onlineUserInfo);
        }
        IFacadeCommon.INSTANCE.updateUserlogin(username, ip);
        this.printDebugList();
    }

    public boolean isOnline(String username, String sessionid, boolean singlelogin, String ip) {
        if (StringTools.isEmpty(username)) {
            return false;
        }
        OnlineUserInfo onlineUserInfo = this.loginUsersMap.get(username);
        if (onlineUserInfo == null) {
            this.addUser(username, sessionid, ip, singlelogin);
            return true;
        }
        logger.debug("\u5b58\u5728\u7684sessionid\uff1a" + onlineUserInfo.getSessionid());
        if (!onlineUserInfo.isSinglelogin()) {
            onlineUserInfo.refreshTime();
            onlineUserInfo.putIpMap(sessionid, ip);
            return true;
        }
        boolean isOnline = onlineUserInfo.getSessionid().equals(sessionid);
        if (isOnline) {
            onlineUserInfo.refreshTime();
            onlineUserInfo.putIpMap(sessionid, ip);
        }
        return isOnline;
    }

    public boolean isOtherLogin(String username, String sessionid) {
        boolean isOtherLogin;
        OnlineUserInfo onlineUserInfo = this.loginUsersMap.get(username);
        if (onlineUserInfo == null) {
            return false;
        }
        logger.debug("\u5b58\u5728\u7684sessionid\uff1a" + onlineUserInfo.getSessionid());
        if (!onlineUserInfo.isSinglelogin()) {
            onlineUserInfo.refreshTime();
            return false;
        }
        boolean bl = isOtherLogin = !onlineUserInfo.getSessionid().equals(sessionid);
        if (!isOtherLogin) {
            onlineUserInfo.refreshTime();
        }
        return isOtherLogin;
    }

    public String getLoginIp(String username, String ipTail) {
        OnlineUserInfo onlineUserInfo = this.loginUsersMap.get(username);
        if (onlineUserInfo == null) {
            return null;
        }
        return onlineUserInfo.toIpString(ipTail);
    }

    public void removeUser(String username, String sessionid) {
        OnlineUserInfo onlineUserInfo = this.loginUsersMap.get(username);
        logger.debug(username + "\u7684session\u8fc7\u671f\uff0c\u8fdb\u884c\u5728\u7ebf\u7528\u6237\u5217\u8868\u66f4\u65b0");
        if (onlineUserInfo != null && (!onlineUserInfo.isSinglelogin() || onlineUserInfo.getSessionid().equals(sessionid))) {
            boolean isOnline = true;
            onlineUserInfo.decreaseCount();
            onlineUserInfo.removeIpMap(sessionid);
            if (onlineUserInfo.getCount() <= 0) {
                logger.debug("\u5220\u9664" + username + "\u7684sessionid\uff1a" + sessionid + "\u8bb0\u5f55");
                isOnline = false;
                this.loginUsersMap.remove(username);
            } else {
                logger.debug("" + username + "\u7684sessionid\uff1a" + sessionid + ",count\u6570\u4e3a\uff1a" + onlineUserInfo.getCount());
            }
            IFacadeCommon.INSTANCE.updateUserlogout(username, isOnline);
            this.printDebugList();
        }
    }

    public OnlineUserInfo getOnlineUserInfo(String username) {
        return this.loginUsersMap.get(username);
    }

    private void printDebugList() {
        if (logger.isDebugEnabled()) {
            for (String u : this.loginUsersMap.keySet()) {
                OnlineUserInfo ou = this.loginUsersMap.get(u);
                logger.debug(ou);
            }
        }
    }
}

