/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibConfig;
import com.xunlei.common.web.bean.PagedDataModel;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@FunRef(value="LibConfig")
public class LibConfigManagedBean
extends AbstractManagedBean {
    public String getQueryLibconfiglist() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("configno asc");
        this.mergePagedDataModel(commfacade.queryLibconfigs(this.findBean(LibConfig.class, 2), fliper), fliper);
        return "";
    }

    public String delete() {
        this.authenticateDel();
        long seqid = this.findParamSeqid();
        if (seqid > 0L) {
            LibConfig data = commfacade.getLibConfigById(seqid);
            commfacade.removeLibConfig(seqid);
        }
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        try {
            for (long seqid : this.findParamSeqids()) {
                commfacade.removeLibConfig(seqid);
            }
        }
        catch (XLRuntimeException e) {
            this.alertJS(e.getMessage());
        }
        this.getQueryLibconfiglist();
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        LibConfig data = this.findBean(LibConfig.class);
        data.setEditby(this.currentUserLogo());
        data.setEdittime(this.now());
        try {
            commfacade.updateLibConfig(data);
            if ("PageSize".equalsIgnoreCase(data.getConfigno())) {
                try {
                    int pagesize;
                    PagedFliper.DEFAULTPAGESIZE = pagesize = Integer.valueOf(data.getConfigvalue()).intValue();
                    PagedDataModel.initPageSizeArray();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if ("siteName".equals(data.getConfigno())) {
                this.getContext().setAttribute("siteName", data.getConfigvalue());
            }
            if ("siteSubName".equals(data.getConfigno())) {
                this.getContext().setAttribute("siteSubName", data.getConfigvalue());
            }
        }
        catch (XLRuntimeException e) {
            this.mergeBean((Object)e.getMessage(), "jsmessage");
        }
        this.getQueryLibconfiglist();
        return "";
    }

    public String add() {
        this.authenticateAdd();
        LibConfig data = this.findBean(LibConfig.class);
        data.setEditby(this.currentUserLogo());
        data.setEdittime(this.now());
        try {
            commfacade.insertLibConfig(data);
            if ("siteName".equals(data.getConfigno())) {
                this.getContext().setAttribute("siteName", data.getConfigvalue());
            }
            if ("siteSubName".equals(data.getConfigno())) {
                this.getContext().setAttribute("siteSubName", data.getConfigvalue());
            }
        }
        catch (XLRuntimeException e) {
            this.mergeBean((Object)e.getMessage(), "jsmessage");
        }
        this.getQueryLibconfiglist();
        return "";
    }

    public String getCsspath() {
        String csspath = null;
        if (null != this.getHttpServletRequest()) {
            csspath = this.getCookie("csspath");
        }
        if (StringTools.isEmpty(csspath)) {
            csspath = ApplicationConfigUtil.getCssPath();
            this.addCookie("csspath", csspath, -1);
        }
        return this.getHttpServletRequest().getContextPath() + csspath;
    }

    public String getEditedRecord() {
        LibConfig data = this.findBean(LibConfig.class);
        if (data.getSeqid() != 0L) {
            this.mergeBean(commfacade.getLibConfigById(data.getSeqid()));
            this.mergeBean((Object)this.getFliper(), "fliper");
        }
        return "";
    }

    public String exportPdf() {
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("configno asc");
        Sheet<LibConfig> sheet = commfacade.queryLibconfigs(null, fliper);
        List list = (List)sheet.getDatas();
        HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
        HttpSession session = (HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(true);
        session.setAttribute("data", list);
        session.setAttribute("class", LibConfig.class);
        session.setAttribute("title", "\u5bfc\u51falibconfig\u793a\u4f8b");
        session.setAttribute("subTitle", "\u8fd9\u91cc\u5bfc\u51fa\u7684\u6570\u636e\u662f\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
        session.setAttribute("filename", DatetimeUtil.now().replaceAll(" ", "_").replaceAll(":", "_") + ".pdf");
        session.setAttribute("exclude", new String[]{"logger", "libconfigMap"});
        session.setAttribute("footString", "\u5bfc\u51fa\u6570\u636e\u7ed3\u675f");
        try {
            response.sendRedirect("exportpdf.jsp");
        }
        catch (Exception ex) {
            // empty catch block
        }
        return "";
    }
}

