/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private static XmlUtil instance;
    private Logger log = Logger.getLogger(XmlUtil.class);

    private XmlUtil() {
    }

    public static synchronized XmlUtil getInstance() {
        if (instance == null) {
            instance = new XmlUtil();
        }
        return instance;
    }

    public Document getXmlFromFile(String xmlfile) {
        try {
            SAXReader saxReader = new SAXReader();
            FileInputStream is = new FileInputStream(xmlfile);
            Document document = saxReader.read(is);
            ((InputStream)is).close();
            return document;
        }
        catch (Exception e) {
            this.log.error(e);
            return null;
        }
    }

    public void writeXmlToFile(String xmlfile, Document document) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter xmlWriter = new XMLWriter(new FileOutputStream(xmlfile), format);
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (Exception e) {
            this.log.error(e);
        }
    }

    public Document string2Document(String s) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(e);
        }
        return doc;
    }

    public String getApplicationConfigElementValue(String elementPath) {
        String result = null;
        try {
            SAXReader saxReader = new SAXReader();
            InputStream is = this.getClass().getResourceAsStream("/applicationConfig.xml");
            Document document = saxReader.read(is);
            is.close();
            Iterator it = document.selectNodes(elementPath).iterator();
            if (it.hasNext()) {
                Element element = (Element)it.next();
                result = element.getText();
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(e);
            return null;
        }
    }

    public List<String> getApplicationConfigElementValues(String elementPath) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            SAXReader saxReader = new SAXReader();
            InputStream is = this.getClass().getResourceAsStream("/applicationConfig.xml");
            Document document = saxReader.read(is);
            is.close();
            Iterator it = document.selectNodes(elementPath).iterator();
            while (it.hasNext()) {
                result.add(((Element)it.next()).getText());
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(e);
            return result;
        }
    }

    public Element getXmlElementByPath(String xmlfile, String elementPath) {
        try {
            Document document = this.getXmlFromFile(xmlfile);
            Iterator it = document.selectNodes(elementPath).iterator();
            if (it.hasNext()) {
                return (Element)it.next();
            }
            return null;
        }
        catch (Exception e) {
            this.log.error(e);
            return null;
        }
    }

    public String getApplicationConfigElementValue(String xmlfile, String elementPath) {
        String result = null;
        try {
            Document document = this.getXmlFromFile(xmlfile);
            Iterator it = document.selectNodes(elementPath).iterator();
            if (it.hasNext()) {
                Element element = (Element)it.next();
                result = element.getText();
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(e);
            return null;
        }
    }

    public List<String> getApplicationConfigElementValues(String xmlfile, String elementPath) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Document document = this.getXmlFromFile(xmlfile);
            Iterator it = document.selectNodes(elementPath).iterator();
            while (it.hasNext()) {
                result.add(((Element)it.next()).getText());
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(e);
            return result;
        }
    }
}

