/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator {
    private static final Pattern pcharanddigit = Pattern.compile("[0-9a-zA-Z]+");
    private static final Pattern pdatey_m_d = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2}");
    private static final Pattern pip4 = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final Pattern pdomain = Pattern.compile("[a-zA-Z0-9-\\u4e00-\\u9fa5]+(.[a-zA-Z0-9-]+)+");
    private static final Pattern pinteger = Pattern.compile("[+-]?\\d+");
    private static final Pattern pnumber = Pattern.compile("\\d+");
    private static final Pattern purl = Pattern.compile("(http:\\/\\/)?+[a-z0-9-]+(\\.[a-z0-9-]+)+(\\/[\\w-\\.\\\\/?%&=]*)?");
    private static final Pattern pemail = Pattern.compile("^[\\w]+[\\w-\\.]*\\@[\\w]+[\\w\\.-]*[\\w]+$");
    private static final Pattern pserialno = Pattern.compile("[a-z0-9-_]+");
    private static final Pattern pdateymd = Pattern.compile("\\d{8}");
    private static final String DOMAINS = ".com.cn|.net.cn|.org.cn|.gov.cn|.com|.net|.tv|.gd|.org|.cc|.vc|.mobi|.cd|.info|.name|.asia|.hk|.me|.la|.sh|.biz|.li|.kr|.in|.us|.io|.ac.cn|.bj.cn|.sh.cn|.tj.cn|.cq.cn|.he.cn|.sx.cn|.nm.cn|.ln.cn|.jl.cn|.hl.cn|.js.cn|.zj.cn|.ah.cn|.fj.cn|.jx.cn|.sd.cn|.ha.cn|.hb.cn|.hn.cn|.gd.cn|.gx.cn|.hi.cn|.sc.cn|.gz.cn|.yn.cn|.xz.cn|.sn.cn|.gs.cn|.qh.cn|.nx.cn|.xj.cn|.tw.cn|.hk.cn|.mo.cn|.cn";

    public static boolean isInteger(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pinteger.matcher(s);
        return m.matches();
    }

    public static boolean isNumber(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pnumber.matcher(s);
        return m.matches();
    }

    public static boolean isURL(String str) {
        if (Validator.isEmpty(str)) {
            return false;
        }
        Matcher m = purl.matcher(str);
        return m.matches();
    }

    public static boolean isEmail(String str) {
        if (Validator.isEmpty(str)) {
            return false;
        }
        str = str.toLowerCase().trim();
        Matcher m = pemail.matcher(str);
        return m.matches();
    }

    public static boolean isSerialNo(String str) {
        if (Validator.isEmpty(str)) {
            return false;
        }
        str = str.toLowerCase().trim();
        Matcher isSerialNo = pserialno.matcher(str);
        return isSerialNo.matches();
    }

    public static boolean isForbid(String str) {
        String[] forbids;
        if (Validator.isEmpty(str)) {
            return false;
        }
        str = str.toLowerCase().trim();
        for (String s : forbids = new String[]{"%", "\\", "'", "*"}) {
            if (str.indexOf(s) <= -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateYMD(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pdateymd.matcher(s);
        return m.matches();
    }

    public static boolean isDateY_M_D(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pdatey_m_d.matcher(s);
        return m.matches();
    }

    public static boolean isCharAndDigit(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pcharanddigit.matcher(s);
        return m.matches();
    }

    public static boolean isEmpty(String s) {
        return null == s || s.trim().equals("");
    }

    public static boolean isNotEmpty(String s) {
        return !Validator.isEmpty(s);
    }

    public static boolean isAllEmpty(String ... str) {
        if (str == null) {
            return true;
        }
        for (String s : str) {
            if (!Validator.isNotEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(String ... str) {
        if (str == null) {
            return false;
        }
        for (String s : str) {
            if (!Validator.isEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isStringBetween(String str, int minLength, int maxLength) {
        if (str == null) {
            return false;
        }
        return str.length() >= minLength && str.length() <= maxLength;
    }

    public static boolean isIP(String s) {
        Matcher m = pip4.matcher(s);
        return m.matches();
    }

    public static boolean isDomain(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pdomain.matcher(s);
        return m.matches();
    }

    public static boolean isNotDomain(String s) {
        return !Validator.isDomain(s);
    }

    public static boolean isMainDomain(String str) {
        String[] domains;
        if (null == str || "".equals(str.trim())) {
            return false;
        }
        for (String s : domains = DOMAINS.split("\\|")) {
            if (null == s || s.trim().equals("") || str.indexOf(s) <= 0) continue;
            return Validator.isSerialNo(str = str.replace(s, ""));
        }
        return false;
    }

    public static void main(String[] a) {
        String s = "http://sss.com.cn.cn.cn";
        System.out.println(Validator.isDomain("qushua.com"));
        System.out.println(Validator.isAllNotEmpty("", "", "d"));
    }
}

