/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.util.Task;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadTool {
    private ThreadPoolExecutor threadPoolExecutor;
    private Future<?> future;

    public ThreadTool(int n) {
        this.threadPoolExecutor = new ThreadPoolExecutor(n, n * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public <T> Future<T> submit(final Task<T> task) {
        Callable call = new Callable<T>(){

            @Override
            public T call() {
                return task.execute();
            }
        };
        Future f = this.threadPoolExecutor.submit(call);
        this.future = f;
        return f;
    }

    public void shutdown() {
        while (!this.future.isDone() || this.threadPoolExecutor.getActiveCount() != 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadPoolExecutor.shutdownNow();
    }
}

