/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFExporter<T> {
    private String titleStr = "";
    private String subTitle = "";
    private List<T> dataList;
    private Class clazz;
    private int totalField;
    private List<String> fieldNameList;
    private String[] tableHaderName;
    private Map<String, String> excludeFieldNameMap = null;
    private String footString;
    private static BaseFont basebf = null;

    public PDFExporter(Class clazz, List<T> dataList, String[] tableHeaderName, String[] excludeFieldNameArray) {
        this.dataList = dataList;
        this.clazz = clazz;
        if (excludeFieldNameArray != null) {
            this.excludeFieldNameMap = new HashMap<String, String>();
            for (String s : excludeFieldNameArray) {
                this.excludeFieldNameMap.put(s, "");
            }
        }
        this.tableHaderName = tableHeaderName;
        this.initClassField();
    }

    public PDFExporter(Class clazz) {
        this.clazz = clazz;
        this.initClassField();
    }

    private void initClassField() {
        if (this.clazz == null) {
            throw new RuntimeException("\u5b9e\u4f53\u7c7b\u578b\u5fc5\u987b\u5b9a\u4e49\uff01");
        }
        Field[] fields = this.clazz.getDeclaredFields();
        this.fieldNameList = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fname = field.getName();
            if (this.excludeFieldNameMap != null && this.excludeFieldNameMap.containsKey(fname)) continue;
            ++this.totalField;
            this.fieldNameList.add(fname);
        }
    }

    public void write(OutputStream out) {
        Document document = new Document(PageSize.A4);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            Font maxfont = new Font(basebf, 15.0f, 0);
            Font font = new Font(basebf, 13.0f, 0);
            Paragraph title = new Paragraph(this.getTitle(), maxfont);
            Chapter chapter = new Chapter(title, 1);
            chapter.setNumberDepth(0);
            Paragraph subtitle = new Paragraph(this.getSubTitle(), font);
            Section section = chapter.addSection(subtitle);
            section.setNumberDepth(0);
            Table t = this.genTable();
            if (t != null) {
                section.add((Object)t);
            }
            if (this.getFootString() != null) {
                section.add((Object)new Paragraph(this.getFootString(), font));
            }
            document.add((Element)chapter);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            document.close();
        }
    }

    public void write(String filePath) {
        try {
            FileOutputStream fo = new FileOutputStream(filePath);
            this.write(fo);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getTitle() {
        return this.titleStr;
    }

    public void setTitle(String titleStr) {
        this.titleStr = titleStr;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    private Table genTable() {
        try {
            Table t = new Table(this.totalField);
            t.setPadding(1.0f);
            t.setSpacing(0.0f);
            t.setBorderWidth(1.0f);
            Font headFont = new Font(basebf, 12.0f, 1);
            for (int i = 0; i < this.totalField; ++i) {
                String headName = this.fieldNameList.get(i);
                if (this.tableHaderName != null && this.tableHaderName.length > i) {
                    headName = this.tableHaderName[i];
                }
                Cell cellHead = new Cell((Element)new Paragraph(headName, headFont));
                t.addCell(cellHead);
            }
            t.endHeaders();
            Font cellFont = new Font(basebf, 12.0f, 0);
            if (this.dataList != null) {
                for (T o : this.dataList) {
                    for (String fieldName : this.fieldNameList) {
                        Method method = this.clazz.getDeclaredMethod("get" + PDFExporter.capitalize(fieldName), new Class[0]);
                        Object value = method.invoke(o, new Object[0]);
                        t.addCell((Phrase)new Paragraph(value + "", cellFont));
                    }
                }
            }
            return t;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public String getFootString() {
        return this.footString;
    }

    public void setFootString(String footString) {
        this.footString = footString;
    }

    static {
        try {
            basebf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

