/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IUsersDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.OnlineUserInfoShow;
import com.xunlei.common.vo.Users;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class UsersDaoImpl
extends JdbcBaseDao
implements IUsersDao {
    @Override
    public Map<String, String> getUpuserlognolist() {
        final HashMap<String, String> datas = new HashMap<String, String>();
        String sql = "select userlogno, truename from users where userlogintype='B' and (upuserlogno is null or upuserlogno='') order by userlogno ";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.put(rs.getString("userlogno"), rs.getString("userlogno") + " " + rs.getString("truename"));
            }
        });
        return datas;
    }

    @Override
    public Map<String, String> getCopartnerNoAndName() {
        final LinkedHashMap<String, String> datas = new LinkedHashMap<String, String>();
        String sql = "select CopartnerNo, concat(concat(ChooseFlag,' - '),CopartnerName) as CopartnerName from copartners where InUse =1 and DeleteStatus=0 and PostStatus=1 and PostStatus=1  order by ChooseFlag";
        logger.debug(sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.put(rs.getString("CopartnerNo"), rs.getString("CopartnerName"));
            }
        });
        return datas;
    }

    @Override
    public Users getUsersByUserLogNo(String userlogno) {
        final ArrayList datas = new ArrayList();
        String sql = "select u.*, c.copartnername from users u left join copartners c on u.copartnerno = c.copartnerno where u.userlogno = ?";
        Object[] params = new Object[]{userlogno};
        this.getJdbcTemplate().query(sql, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Users data = new Users();
                data.setSeqid(rs.getLong("seqid"));
                data.setUserlogno(rs.getString("userlogno"));
                data.setUserpassword(rs.getString("userpassword"));
                data.setSuperman(rs.getShort("superman"));
                data.setCopartnerno(rs.getString("copartnerno"));
                data.setCopartnername(rs.getString("copartnername"));
                data.setInuse(rs.getShort("inuse"));
                data.setTruename(rs.getString("truename"));
                data.setBindip(rs.getString("bindip"));
                data.setTel(rs.getString("tel"));
                data.setQq(rs.getString("qq"));
                data.setEmail(rs.getString("email"));
                data.setWorkingplatform(rs.getString("workingplatform"));
                data.setStartvaliddate(rs.getString("startvaliddate"));
                data.setEndvaliddate(rs.getString("endvaliddate"));
                data.setUpuserlogno(rs.getString("upuserlogno"));
                data.setUserlogintype(rs.getString("userlogintype"));
                data.setSinglelogin(rs.getShort("singlelogin"));
                datas.add(data);
            }
        });
        if (datas.size() == 0) {
            return null;
        }
        Users user = (Users)datas.get(0);
        return user;
    }

    @Override
    public void insertUsers(Users data) {
        this.saveObject(data);
    }

    @Override
    public void updateUsers(Users data) {
        this.updateObject(data);
    }

    @Override
    public void removeUsers(Users data) {
        this.deleteObject(data);
    }

    @Override
    public void removeUsers(long seqid) {
        this.deleteObject("users", seqid);
    }

    @Override
    @Deprecated
    public int getUsersViewCount(Users u) {
        String sql = "select count(*) from users u";
        String condition = "";
        if (u != null) {
            if (this.isNotEmpty(u.getCopartnerno())) {
                condition = condition + " u.copartnerno like '%" + u.getCopartnerno() + "%' and ";
            }
            if (this.isNotEmpty(u.getUserlogno())) {
                condition = condition + " u.userlogno like '%" + u.getUserlogno() + "%' and ";
            }
            if (this.isNotEmpty(condition)) {
                sql = sql + " where " + condition.substring(0, condition.length() - 4);
            }
        }
        return super.getSingleInt(sql);
    }

    @Override
    @Deprecated
    public List<Users> getUsersView(Users u, int rowcount, int pagesize, int pageno, String sortColumn) {
        final ArrayList<Users> datas = new ArrayList<Users>();
        String sql = "select u.*, c.copartnername from users u left join copartners c on u.copartnerno = c.copartnerno ";
        String condition = "";
        if (u != null) {
            if (this.isNotEmpty(u.getCopartnerno())) {
                condition = condition + " u.copartnerno like '%" + u.getCopartnerno() + "%' and ";
            }
            if (this.isNotEmpty(u.getUserlogno())) {
                condition = condition + " u.userlogno like '%" + u.getUserlogno() + "%' and ";
            }
            if (this.isNotEmpty(u.getTruename())) {
                condition = condition + " u.truename like '%" + u.getTruename() + "%' and ";
            }
            if (this.isNotEmpty(condition)) {
                sql = sql + " where " + condition.substring(0, condition.length() - 4);
            }
        }
        sql = sql + "order by " + (this.isEmpty(sortColumn) ? "UserLogNo asc " : sortColumn);
        sql = this.addLimitToSql(sql, rowcount, pagesize, pageno);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Users data = new Users();
                data.setSeqid(rs.getLong("seqid"));
                data.setUserlogno(rs.getString("userlogno"));
                data.setSuperman(rs.getShort("superman"));
                data.setCopartnerno(rs.getString("copartnerno"));
                data.setBindip(rs.getString("bindip"));
                data.setCopartnername(rs.getString("copartnername"));
                data.setInuse(rs.getShort("inuse"));
                data.setTel(rs.getString("tel"));
                data.setQq(rs.getString("qq"));
                data.setEmail(rs.getString("email"));
                data.setStartvaliddate(rs.getString("startvaliddate"));
                data.setEndvaliddate(rs.getString("endvaliddate"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<Users> getCopartnerNoNameForUsers(Short checkstatus) {
        final ArrayList<Users> datas = new ArrayList<Users>();
        String sql = "";
        sql = checkstatus == null ? "select seqid,chooseflag,copartnerno,copartnername from copartners where inuse=1 and deletestatus=0 order by copartnername" : "select seqid,chooseflag,copartnerno,copartnername from copartners where inuse=1 and deletestatus=0 and checkstatus = " + checkstatus + " order by copartnername";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Users data = new Users();
                data.setSeqid(rs.getLong("seqid"));
                data.setCopartnerno(rs.getString("copartnerno"));
                data.setCopartnername(rs.getString("copartnername"));
                String chooseflag = rs.getString("chooseflag");
                chooseflag = chooseflag == null ? "" : chooseflag.toUpperCase();
                data.setCopartnername(chooseflag + " - " + data.getCopartnername());
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public boolean getIfMyDataOnly(String userlogno) {
        String sql = "select count(*) from roles where RoleNo in ( select RoleNo from usertorole where UserLogNo='" + userlogno + "' and RoleType='SYS') and DataControl = 1 ";
        return super.getSingleInt(sql) > 0;
    }

    @Override
    public List<String> getAllUserLogo() {
        final ArrayList<String> datas = new ArrayList<String>();
        String sql = "select u.userlogno from users u where u.INUSE= 1  order by u.userlogno ";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.add(rs.getString("userlogno"));
            }
        });
        return datas;
    }

    @Override
    public Sheet<Users> querySysUsers(Users u, PagedFliper fliper) {
        String where = " where 1=1 and ";
        if (u != null && this.isNotEmpty(u.getUserlogno())) {
            where = where + " UserLogNo like '%" + u.getUserlogno() + "%' and ";
        }
        where = where + " (CopartnerNo is null or CopartnerNo='') ";
        String countsql = " select count(*) from users " + where;
        int rowcount = super.getSingleInt(countsql);
        if (rowcount == 0) {
            return Sheet.EMPTY;
        }
        String sql = "select * from users " + where;
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<Users>(rowcount, this.query(Users.class, sql, new String[0]));
    }

    @Override
    public Sheet<Users> queryAllUsers(Users u, PagedFliper fliper) {
        String countsql;
        int rowcount;
        String where = " where 1=1  ";
        if (u != null) {
            if (this.isNotEmpty(u.getUserlogno())) {
                where = where + " and u.UserLogNo like '%" + u.getUserlogno() + "%' ";
            }
            if (this.isNotEmpty(u.getTruename())) {
                where = where + " and u.truename like '%" + u.getTruename() + "%' ";
            }
        }
        if ((rowcount = super.getSingleInt(countsql = " select count(u.SeqId) from users u left join copartners c  on  u.CopartnerNo =c.CopartnerNo " + where)) == 0) {
            return Sheet.EMPTY;
        }
        String sql = " select u.*, c.copartnername from users u left join copartners c  on  u.CopartnerNo =c.CopartnerNo " + where;
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<Users>(rowcount, this.query(Users.class, sql, "copartnername"));
    }

    @Override
    public Sheet<OnlineUserInfoShow> queryAllUsersWithOnlineInfo(OnlineUserInfoShow onlineUserInfoShow, PagedFliper fliper) {
        StringBuilder where = new StringBuilder(" where 1=1  ");
        if (onlineUserInfoShow != null) {
            if (this.isNotEmpty(onlineUserInfoShow.getUsername())) {
                where.append(" and u.UserLogNo like '%").append(onlineUserInfoShow.getUsername()).append("%' ");
            }
            if (onlineUserInfoShow.getStatus() == 2) {
                where.append(" and uo.isonline=2 ");
            } else if (onlineUserInfoShow.getStatus() == 1) {
                where.append(" and u.userlogno not in(select userlogno from useronline where isonline=2) ");
            }
        }
        String sql = " select u.userlogno as username,uo.isonline as status,uo.lastlogintime as lastlogintime,uo.lastlogouttime as lastlogouttime,uo.lastloginip as ips,'' as updatetime from users u left join useronline uo on u.userlogno=uo.userlogno " + where;
        String countsql = " select count(1) from users u left join useronline uo on u.userlogno=uo.userlogno " + where;
        int rowcount = super.getSingleInt(countsql);
        if (rowcount == 0) {
            return Sheet.EMPTY;
        }
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<OnlineUserInfoShow>(rowcount, this.query(OnlineUserInfoShow.class, sql, new String[0]));
    }

    @Override
    public Sheet<Users> queryCopUsers(Users u, PagedFliper fliper) {
        String countsql;
        int rowcount;
        String where = " where u.CopartnerNo =c.CopartnerNo and u.CopartnerNo is not null and u.CopartnerNo != '' ";
        if (u != null) {
            if (this.isNotEmpty(u.getUserlogno())) {
                where = where + " and u.UserLogNo like '%" + u.getUserlogno() + "%' ";
            }
            if (this.isNotEmpty(u.getCopartnername())) {
                where = where + " and c.copartnername like '%" + u.getCopartnername() + "%' ";
            }
        }
        if ((rowcount = super.getSingleInt(countsql = " select count(u.SeqId) from users u, copartners c " + where)) == 0) {
            return Sheet.EMPTY;
        }
        String sql = " select u.*, c.copartnername from users u, copartners c " + where;
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<Users>(rowcount, this.query(Users.class, sql, "copartnername"));
    }

    @Override
    public int getCountUsers(Users data) {
        String sql = "select count(1) from users u";
        String condition = "";
        if (data != null) {
            if (this.isNotEmpty(data.getCopartnerno())) {
                condition = condition + " u.copartnerno = '" + data.getCopartnerno() + "' and ";
            }
            if (this.isNotEmpty(data.getUpuserlogno())) {
                condition = condition + " u.upuserlogno = '" + data.getUpuserlogno() + "' and ";
            }
            if (this.isNotEmpty(condition)) {
                sql = sql + " where " + condition.substring(0, condition.length() - 4);
            }
        }
        return super.getSingleInt(sql);
    }

    @Override
    public boolean isSuperMan(Users u) {
        if (u == null || this.isEmpty(u.getUserlogno()) && this.isEmpty(u.getTruename())) {
            return false;
        }
        String sql = "select count(*) from users u";
        String condition = " where u.superman =1 ";
        if (this.isNotEmpty(u.getUserlogno())) {
            condition = condition + " and u.userlogno = '" + u.getUserlogno() + "'  ";
        }
        if (this.isNotEmpty(u.getTruename())) {
            condition = condition + " and u.truename = '" + u.getTruename() + "' ";
        }
        return super.getSingleInt(sql = sql + condition) > 0;
    }

    @Override
    public Users findAUsers(Users users) {
        return this.findObjectByCondition(users);
    }

    @Override
    public Users getAUsers(Users u) {
        return this.findObject(u);
    }

    @Override
    public Sheet<Users> queryUsers(Users u, PagedFliper fliper) {
        return this.findPagedObjects(u, null, fliper);
    }

    @Override
    public String[] getFrontUsersLognoAndTrueName() {
        String sql = "select userlogno,truename from users where userlogintype='B'";
        final ArrayList list = new ArrayList();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String str = rs.getString("userlogno") + "|";
                str = str + rs.getString("truename");
                list.add(str);
            }
        });
        return list.toArray(new String[list.size()]);
    }
}

