/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IUserToRoleDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.UserToRole;
import com.xunlei.common.vo.Users;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class UserToRoleDaoImpl
extends JdbcBaseDao
implements IUserToRoleDao {
    @Override
    public List<UserToRole> getAllUserToRole() {
        return this.findObjects(new UserToRole(), null, null);
    }

    @Override
    public void insertUserToRole(UserToRole data) {
        this.saveObject(data);
    }

    @Override
    public void updateUserToRole(UserToRole data) {
        this.updateObject(data);
    }

    @Override
    public void updateUserToRoleByUserLogno(UserToRole data) {
        String updSql = "update usertorole set ROLENO='" + data.getRoleno() + "' where USERLOGNO='" + data.getUserlogno() + "' and ROLETYPE='" + data.getRoletype() + "'";
        this.getJdbcTemplate().update(updSql);
    }

    @Override
    public void removeUserToRole(UserToRole data) {
        this.deleteObject(data);
    }

    @Override
    public List<Users> getAllUsersInRoles(Roles role) {
        final ArrayList<Users> datas = new ArrayList<Users>();
        String sql = "select u.*, c.copartnername as 'copartnername' from users u   left join copartners c on u.copartnerno = c.copartnerno  where (u.upuserlogno is null or u.upuserlogno='') and u.USERLOGNO in (select UserLogNo from usertorole  where RoleNo='" + role.getRoleno() + "' and RoleType='" + role.getRoletype() + "') ";
        if (this.isNotEmpty(role.getUserlogintype())) {
            sql = sql + " and u.userlogintype='" + role.getUserlogintype() + "' ";
        }
        sql = sql + " order by u.userlogno, u.copartnerno";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Users data = new Users();
                data.setSeqid(rs.getLong("seqid"));
                data.setUserlogno(rs.getString("userlogno"));
                data.setSuperman(rs.getShort("superman"));
                data.setCopartnername(rs.getString("copartnername"));
                data.setInuse(rs.getShort("inuse"));
                data.setTruename(rs.getString("TrueName"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<Users> getAllUsersNotInRoles(Roles role) {
        final ArrayList<Users> datas = new ArrayList<Users>();
        String sql = "select u.*, ifnull(c.copartnername,'') as 'copartnername' from users u   left join copartners c on u.copartnerno = c.copartnerno  where (u.upuserlogno is null or u.upuserlogno='') and u.USERLOGNO not in (select UserLogNo from usertorole  where RoleNo='" + role.getRoleno() + "' and RoleType='" + role.getRoletype() + "') ";
        if (this.isNotEmpty(role.getUserlogintype())) {
            sql = sql + " and u.userlogintype='" + role.getUserlogintype() + "' ";
        }
        sql = sql + " order by u.userlogno, u.copartnerno";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Users data = new Users();
                data.setSeqid(rs.getLong("seqid"));
                data.setUserlogno(rs.getString("userlogno"));
                data.setSuperman(rs.getShort("superman"));
                data.setCopartnername(rs.getString("copartnername"));
                data.setInuse(rs.getShort("inuse"));
                data.setTruename(rs.getString("TrueName"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public void addUsersInRoles(Roles role, long[] userseqids) {
        String sql = "insert into usertorole(RoleNo, RoleType, UserLogNo)  select '" + role.getRoleno() + "', '" + role.getRoletype() + "', u.USERLOGNO from users u where SEQID in " + UserToRoleDaoImpl.uniteLongArray(userseqids);
        this.getJdbcTemplate().update(sql);
    }

    @Override
    public void removeUsersfromUserToRoles(Roles role, long[] userseqids) {
        String sql = "delete from usertorole where RoleNo='" + role.getRoleno() + "' " + "and RoleType='" + role.getRoletype() + "' and UserLogNo in (select USERLOGNO from users where SEQID in " + UserToRoleDaoImpl.uniteLongArray(userseqids) + " )";
        this.getJdbcTemplate().update(sql);
    }

    @Override
    public void removeRolesfromUserToRoles(Users user, long[] roleseqids) {
        for (long id : roleseqids) {
            String sql = "delete from usertorole where userlogno='" + user.getUserlogno() + "' and roleno in(select r.roleno from roles r where r.seqid=" + id + ") and roletype in(select r.roletype from roles r where r.seqid=" + id + ")";
            this.executeUpdate(sql);
        }
    }

    @Override
    public void addRolestoUserToRoles(Users user, long[] roleseqids) {
        for (long id : roleseqids) {
            String sql = "insert into usertorole(RoleNo, RoleType, UserLogNo)  values((select r.roleno from roles r where r.seqid=" + id + ") ,(select r.roletype from roles r where r.seqid=" + id + "),'" + user.getUserlogno() + "' ) ";
            this.executeUpdate(sql);
        }
    }

    private static String uniteLongArray(long[] userseqids) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < userseqids.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(userseqids[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Sheet<UserToRole> getRolesByUser(Users u, PagedFliper fliper) {
        if (u == null) {
            return Sheet.EMPTY;
        }
        String where = "where u.UserLogNo in ( select UserLogNo from users  where 1=1 and ";
        if (this.isNotEmpty(u.getUserlogno())) {
            where = where + " userlogno like '%" + u.getUserlogno() + "%' and ";
        }
        if (this.isNotEmpty(u.getTruename())) {
            where = where + " truename like '%" + u.getTruename() + "%' and ";
        }
        where = where + " 1=1 )";
        String countsql = " select  count(u.SeqId) from usertorole u " + where;
        int rowcount = super.getSingleInt(countsql);
        if (rowcount == 0) {
            return Sheet.EMPTY;
        }
        String sql = "select u.*, r.rolename from usertorole u left join roles r on u.roleno =r.roleno and u.roletype = r.roletype " + where;
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<UserToRole>(rowcount, this.query(UserToRole.class, sql, "rolename"));
    }

    @Override
    public void updateDefaultRole(Users u) {
        if (u != null && u.getSeqid() != 0L) {
            String sql1 = "update usertorole u set u.defaultrole=0 where u.defaultrole=1";
            this.executeUpdate(sql1);
            String sql2 = "update usertorole u set u.defaultrole=1 where u.seqid=" + u.getSeqid();
            this.executeUpdate(sql2);
        }
    }

    @Override
    public UserToRole getUserToRoleById(long seqid) {
        UserToRole ur = new UserToRole();
        ur.setSeqid(seqid);
        return this.findObject(ur);
    }

    @Override
    public List<UserToRole> getUserToRole(UserToRole ur) {
        return this.findObjects(ur, null, null);
    }

    @Override
    public int getUserToRoleByUserLogNo(String userlogno) {
        String sql = "select count(*) from usertorole  where UserLogNo= '" + userlogno + "'";
        return super.getSingleInt(sql);
    }

    @Override
    public Sheet<UserToRole> queryUserToRoles(UserToRole data, PagedFliper fliper) {
        return this.findPagedObjects(data, null, fliper);
    }
}

