/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IRoleRightsDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.RoleRights;
import com.xunlei.common.vo.Users;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class RoleRightsDaoImpl
extends JdbcBaseDao
implements IRoleRightsDao {
    @Override
    public List<RoleRights> getRoleRights(RoleRights roleRights) {
        return this.findObjects(roleRights, null, null);
    }

    @Override
    public void insertRoleRights(RoleRights data) {
        this.saveObject(data);
    }

    @Override
    public void updateRoleRights(RoleRights data) {
        this.updateObject(data);
    }

    @Override
    public void removeRoleRights(RoleRights data) {
        this.deleteObject(data);
    }

    @Override
    public RoleRights getARoleRights(RoleRights roleRights) {
        return this.findObjectByCondition(roleRights);
    }

    @Override
    public List<RoleRights> getRoleRightsByRoleNoAndModuleNo(String roleno, String moduleno, String sortColumn) {
        final ArrayList<RoleRights> datas = new ArrayList<RoleRights>();
        String sql = "select rr.seqid,rr.roleno,rr.funcno,f.funcname,rr.enablerun,rr.enableadd, rr.enableedit, f.haverun,f.haveadd,f.haveedit,f.havedel, f.HAVEPLUS as 'fullplus', rr.enabledel,rr.enableplus from rolerights rr left join functions f on rr.funcno = f.funcno where rr.roleno = ? and f.moduleno = ? ";
        if (this.isNotEmpty(sortColumn)) {
            sql = sql + "order by " + sortColumn;
        }
        Object[] params = new Object[]{roleno, moduleno};
        logger.debug(sql);
        this.getJdbcTemplate().query(sql, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                RoleRights data = new RoleRights();
                data.setSeqid(rs.getLong("seqid"));
                data.setRoleno(rs.getString("roleno"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                if (rs.getShort("haverun") > 0) {
                    data.setEnablerun(rs.getShort("enablerun"));
                } else {
                    data.setEnablerun((short)-1);
                }
                if (rs.getShort("haveadd") > 0) {
                    data.setEnableadd(rs.getShort("enableadd"));
                } else {
                    data.setEnableadd((short)-1);
                }
                if (rs.getShort("haveedit") > 0) {
                    data.setEnableedit(rs.getShort("enableedit"));
                } else {
                    data.setEnableedit((short)-1);
                }
                if (rs.getShort("havedel") > 0) {
                    data.setEnabledel(rs.getShort("enabledel"));
                } else {
                    data.setEnabledel((short)-1);
                }
                data.setEnableplus(rs.getString("enableplus"));
                data.setFuncfullplus(rs.getString("fullplus"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<RoleRights> getRoleRightsByUserAndModuleNo(Users user, String moduleno, String sortColumn) {
        if (user == null || this.isEmpty(moduleno)) {
            return null;
        }
        String userlogno = user.getUserlogno();
        String truename = user.getTruename();
        String sql = "select rr.seqid,rr.roleno,rr.funcno,f.funcname,rr.enablerun,rr.enableadd, rr.enableedit, f.haverun,f.haveadd,f.haveedit,f.havedel, f.HAVEPLUS as 'fullplus', rr.enabledel,rr.enableplus from rolerights rr left join functions f on rr.funcno = f.funcno where rr.roleno in ( select RoleNo from usertorole ur left join users u on ur.UserLogNo = u.UserLogNo ";
        String condition = "";
        if (this.isNotEmpty(userlogno)) {
            condition = condition + " u.UserLogNo ='" + userlogno + "' and ";
        }
        if (this.isNotEmpty(truename)) {
            condition = condition + " u.TrueName ='" + truename + "' and ";
        }
        if (this.isNotEmpty(condition)) {
            sql = sql + " where " + condition.substring(0, condition.length() - 4);
        }
        sql = sql + ") and f.moduleno = '" + moduleno + "'";
        final ArrayList<RoleRights> datas = new ArrayList<RoleRights>();
        if (this.isNotEmpty(sortColumn)) {
            sql = sql + "order by " + sortColumn;
        }
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                RoleRights data = new RoleRights();
                data.setSeqid(rs.getLong("seqid"));
                data.setRoleno(rs.getString("roleno"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                if (rs.getShort("haverun") > 0) {
                    data.setEnablerun(rs.getShort("enablerun"));
                } else {
                    data.setEnablerun((short)-1);
                }
                if (rs.getShort("haveadd") > 0) {
                    data.setEnableadd(rs.getShort("enableadd"));
                } else {
                    data.setEnableadd((short)-1);
                }
                if (rs.getShort("haveedit") > 0) {
                    data.setEnableedit(rs.getShort("enableedit"));
                } else {
                    data.setEnableedit((short)-1);
                }
                if (rs.getShort("havedel") > 0) {
                    data.setEnabledel(rs.getShort("enabledel"));
                } else {
                    data.setEnabledel((short)-1);
                }
                data.setEnableplus(rs.getString("enableplus"));
                data.setFuncfullplus(rs.getString("fullplus"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<RoleRights> getRoleRightsBySubuserAndModuleNo(Users user, String moduleno, String sortColumn) {
        if (user == null || this.isEmpty(moduleno)) {
            return null;
        }
        String userlogno = user.getUserlogno();
        String truename = user.getTruename();
        String sql = "select rr.seqid,rr.roleno,rr.funcno,f.funcname,rr.enablerun,rr.enableadd, rr.enableedit, f.haverun,f.haveadd,f.haveedit,f.havedel, f.HAVEPLUS as 'fullplus',  rr.enabledel,rr.enableplus from rolerights rr left join functions f on  rr.funcno = f.funcno where rr.roleno in ( select RoleNo from usertorole ur left join users u on ur.UserLogNo = u.UserLogNo  where u.UserLogNo in( select UpUserLogNo from users u1 ";
        String condition = "";
        if (this.isNotEmpty(userlogno)) {
            condition = condition + " u1.UserLogNo ='" + userlogno + "' and ";
        }
        if (this.isNotEmpty(truename)) {
            condition = condition + " u1.TrueName ='" + truename + "' and ";
        }
        if (this.isNotEmpty(condition)) {
            sql = sql + " where " + condition.substring(0, condition.length() - 4);
        }
        sql = sql + ")) and f.moduleno = '" + moduleno + "' and f.funcno in (select FuncNo from usertofunction uf where 1=1 ";
        if (this.isNotEmpty(userlogno)) {
            sql = sql + " and  uf.UserLogNo ='" + userlogno + "'";
        }
        if (this.isEmpty(userlogno) && this.isNotEmpty(truename)) {
            sql = sql + " and  uf.UserLogNo in( select UserLogNo from users u2 where TrueName= '" + truename + "')";
        }
        sql = sql + ") ";
        final ArrayList<RoleRights> datas = new ArrayList<RoleRights>();
        if (this.isNotEmpty(sortColumn)) {
            sql = sql + "order by " + sortColumn;
        }
        logger.debug("sql=" + sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                RoleRights data = new RoleRights();
                data.setSeqid(rs.getLong("seqid"));
                data.setRoleno(rs.getString("roleno"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                if (rs.getShort("haverun") > 0) {
                    data.setEnablerun(rs.getShort("enablerun"));
                } else {
                    data.setEnablerun((short)-1);
                }
                if (rs.getShort("haveadd") > 0) {
                    data.setEnableadd(rs.getShort("enableadd"));
                } else {
                    data.setEnableadd((short)-1);
                }
                if (rs.getShort("haveedit") > 0) {
                    data.setEnableedit(rs.getShort("enableedit"));
                } else {
                    data.setEnableedit((short)-1);
                }
                if (rs.getShort("havedel") > 0) {
                    data.setEnabledel(rs.getShort("enabledel"));
                } else {
                    data.setEnabledel((short)-1);
                }
                data.setEnableplus(rs.getString("enableplus"));
                data.setFuncfullplus(rs.getString("fullplus"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<LibClassD> getModelNoByUser(Users user) {
        if (user == null || this.isEmpty(user.getUserlogno()) && this.isEmpty(user.getTruename())) {
            return null;
        }
        String userlogno = user.getUserlogno();
        String truename = user.getTruename();
        final ArrayList<LibClassD> datas = new ArrayList<LibClassD>();
        String sql = "select classitemid, itemname,itemno from libclassd where classitemid in (select distinct ModuleNo from rolerights r left join  functions f on r.FuncNo = f.FuncNo where RoleNo in ( select RoleNo from usertorole ur left join users u on ur.UserLogNo = u.UserLogNo   ";
        String condition = "";
        if (this.isNotEmpty(userlogno)) {
            condition = condition + "  u.UserLogNo ='" + userlogno + "' and ";
        }
        if (this.isNotEmpty(truename)) {
            condition = condition + " u.truename ='" + truename + "' and ";
        }
        if (this.isNotEmpty(condition)) {
            sql = sql + " where " + condition.substring(0, condition.length() - 4);
        }
        sql = sql + " ) order by ModuleNo asc)";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                LibClassD data = new LibClassD();
                data.setItemname(rs.getString("itemname"));
                data.setClassitemid(rs.getString("classitemid"));
                data.setItemno(rs.getString("itemno"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<RoleRights> getRoleRightsByRoleList(String[] roles) {
        if (roles == null || roles.length == 0) {
            return new ArrayList<RoleRights>();
        }
        String sql = "SELECT rr.seqid as seqid,roleno,rr.funcno as funcno,rr.enablerun as enablerun,rr.enableadd as enableadd,rr.enableedit as enableedit,rr.enabledel as enabledel,rr.enableplus as enableplus,f.funcname as funcname FROM rolerights rr Inner Join functions f ON rr.FuncNo = f.FuncNo where rr.roleno in " + RoleRightsDaoImpl.uniteForIn(roles);
        return this.query(RoleRights.class, sql, "funcname");
    }
}

