/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IAdvsDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.Advs;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class AdvsDaoImpl
extends JdbcBaseDao
implements IAdvsDao {
    @Override
    public Advs getAdvsById(long seqid) {
        Advs p = new Advs();
        p.setSeqid(seqid);
        return this.findObject(p);
    }

    @Override
    public Advs insertAdvs(Advs data) {
        return this.saveObject(data);
    }

    @Override
    public void updateAdvs(Advs data) {
        this.updateObject(data);
    }

    @Override
    public void deleteAdvsById(long seqid) {
        Advs p = new Advs();
        p.setSeqid(seqid);
        this.deleteAdvs(p);
    }

    @Override
    public void deleteAdvs(Advs data) {
        this.deleteObjectByCondition(data, null);
    }

    @Override
    public Sheet<Advs> queryAdvs(Advs data, PagedFliper fliper) {
        int rowcount;
        String sql = "select a.*,p.placename from advs a left join advplace p on a.placeid = p.placeid and a.flatno = p.flatno ";
        String countsql = "select count(a.seqid) from advs a left join advplace p on a.placeid = p.placeid and a.flatno = p.flatno ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getFlatno())) {
                where.append(" and a.flatno = '").append(data.getFlatno()).append("'");
            }
            if (this.isNotEmpty(data.getPlaceid())) {
                where.append(" and a.placeid = '").append(data.getPlaceid()).append("'");
            }
            if (this.isNotEmpty(data.getAdvtitlelike())) {
                where.append(" and advtitle like '%").append(StringTools.escapeSql(data.getAdvtitlelike())).append("%' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<Advs>(rowcount, this.query(Advs.class, sql, "placename"));
    }

    @Override
    public synchronized String newAdvid() {
        String sql = "select max(advId) as advId from advs";
        final ArrayList<Integer> maxAdvId = new ArrayList<Integer>();
        this.getJdbcTemplate().query("select max(advId) as advId from advs", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    maxAdvId.add(Integer.parseInt(rs.getString("advId")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (maxAdvId.size() == 0) {
            maxAdvId.add(new Integer(0));
        }
        int advId = (Integer)maxAdvId.get(0);
        String idstr = "0000" + ++advId;
        return idstr.substring(idstr.length() - 4);
    }
}

