/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.BaseBo;
import com.xunlei.common.bo.IUserToRoleBo;
import com.xunlei.common.dao.IUserToRoleDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.UserToRole;
import com.xunlei.common.vo.Users;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class UserToRoleBoImpl
extends BaseBo
implements IUserToRoleBo {
    @Autowired
    private IUserToRoleDao userToRoleDao;

    public IUserToRoleDao getUserToRoleDao() {
        return this.userToRoleDao;
    }

    @Override
    public void setUserToRoleDao(IUserToRoleDao userToRoleDao) {
        this.userToRoleDao = userToRoleDao;
    }

    @Override
    public List<Users> getAllUsersInRoles(Roles role) {
        return this.getUserToRoleDao().getAllUsersInRoles(role);
    }

    @Override
    public List<Users> getAllUsersNotInRoles(Roles role) {
        return this.getUserToRoleDao().getAllUsersNotInRoles(role);
    }

    @Override
    public List<UserToRole> getAllUserToRole() {
        return this.getUserToRoleDao().getAllUserToRole();
    }

    @Override
    public UserToRole getUserToRoleById(Long id) {
        return this.getUserToRoleDao().getUserToRoleById(id);
    }

    @Override
    public List<UserToRole> getUserToRoleByUserLogo(String userlogo) {
        UserToRole ur = new UserToRole();
        ur.setUserlogno(userlogo);
        return this.getUserToRoleDao().getUserToRole(ur);
    }

    @Override
    public void insertUserToRole(UserToRole data) {
        this.getUserToRoleDao().insertUserToRole(data);
    }

    @Override
    public void updateUserToRole(UserToRole data) {
        this.getUserToRoleDao().updateUserToRole(data);
    }

    @Override
    public void updateUserToRoleByUserLogno(UserToRole data) {
        this.getUserToRoleDao().updateUserToRoleByUserLogno(data);
    }

    @Override
    public void removeUserToRole(UserToRole data) {
        data = this.getUserToRoleById(data.getSeqid());
        this.getUserToRoleDao().removeUserToRole(data);
    }

    @Override
    public void removeUserToRole(String roleno, String roletype, String userlogno) {
        UserToRole ur = new UserToRole();
        ur.setRoleno(roleno);
        ur.setRoletype(roletype);
        ur.setUserlogno(userlogno);
        Sheet<UserToRole> datas = this.getUserToRoleDao().queryUserToRoles(ur, null);
        for (UserToRole r : datas.getDatas()) {
            this.getUserToRoleDao().deleteObject(r);
        }
    }

    @Override
    public void addUsersInRoles(Roles role, long[] userseqids) {
        this.getUserToRoleDao().addUsersInRoles(role, userseqids);
    }

    @Override
    public void removeUsersfromUserToRoles(Roles role, long[] userseqids) {
        this.getUserToRoleDao().removeUsersfromUserToRoles(role, userseqids);
    }

    @Override
    public Sheet<UserToRole> getRolesByUser(Users u, PagedFliper fliper) {
        return this.getUserToRoleDao().getRolesByUser(u, fliper);
    }

    @Override
    public void updateDefaultRole(Users u) {
        this.getUserToRoleDao().updateDefaultRole(u);
    }

    @Override
    public int getUserToRoleByUserLogNo(String userlogno) {
        return this.getUserToRoleDao().getUserToRoleByUserLogNo(userlogno);
    }

    @Override
    public void removeRolesfromUserToRoles(Users user, long[] roleseqids) {
        this.getUserToRoleDao().removeRolesfromUserToRoles(user, roleseqids);
    }

    @Override
    public void addRolestoUserToRoles(Users user, long[] roleseqids) {
        this.getUserToRoleDao().addRolestoUserToRoles(user, roleseqids);
    }

    @Override
    public Sheet<UserToRole> queryUserToRoles(UserToRole data, PagedFliper fliper) {
        return this.getUserToRoleDao().queryUserToRoles(data, fliper);
    }
}

