/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.IMailclassBo;
import com.xunlei.common.dao.IMailclassDao;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Mailclass;
import com.xunlei.common.vo.UsersNoAndName;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class MailclassBoImpl
implements IMailclassBo {
    @Autowired
    private IMailclassDao MailclassDaoImpl;

    @Override
    public Mailclass getMailclassById(long seqid) {
        return this.MailclassDaoImpl.getMailclassById(seqid);
    }

    @Override
    public Mailclass insertMailclass(Mailclass data) {
        if (this.isExist(data.getClassid(), data.getClassname())) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u6216\u540d\u79f0\u7684\u90ae\u4ef6\u5206\u7ec4\uff01");
        }
        data.setInputtime(DatetimeUtil.now());
        return this.MailclassDaoImpl.insertMailclass(data);
    }

    @Override
    public void updateMailclass(Mailclass data) {
        Mailclass omc = this.getMailclassById(data.getSeqid());
        if (omc != null) {
            if (this.isExistClassNameButNoClassid(data.getClassname(), omc.getClassid())) {
                throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u90ae\u4ef6\u5206\u7ec4\uff01");
            }
            omc.setClassname(data.getClassname());
            omc.setRemark(data.getRemark());
            omc.setEditby(data.getEditby());
            omc.setFrontshow(data.getFrontshow());
            omc.setEdittime(DatetimeUtil.now());
            this.MailclassDaoImpl.updateMailclass(omc);
        }
    }

    @Override
    public void deleteMailclassById(long seqid) {
        Mailclass mailclass = this.getMailclassById(seqid);
        if (mailclass != null) {
            List<UsersNoAndName> list = IFacadeCommon.INSTANCE.getAllUsersInMailclass(mailclass.getClassid());
            if (list.size() > 0) {
                throw new XLRuntimeException("\u90ae\u4ef6\u5206\u7c7b\uff08" + mailclass.getClassname() + "\uff09\u56e0\u88ab\u5f15\u7528\u800c\u65e0\u6cd5\u5220\u9664\uff1b");
            }
            this.MailclassDaoImpl.deleteMailclassById(seqid);
        }
    }

    @Override
    public void deleteMailclass(Mailclass data) {
        this.MailclassDaoImpl.deleteMailclass(data);
    }

    @Override
    public Sheet<Mailclass> queryMailclass(Mailclass data, PagedFliper fliper) {
        return this.MailclassDaoImpl.queryMailclass(data, fliper);
    }

    @Override
    public List<Mailclass> queryMailclass(Mailclass data) {
        return this.MailclassDaoImpl.queryMailclass(data);
    }

    @Override
    public List<Mailclass> queryMailclassbyusername(String username) {
        return this.MailclassDaoImpl.queryMailclassbyusername(username);
    }

    @Override
    public String[] queryMailclassidbyusername(String username) {
        List<Mailclass> list = this.queryMailclassbyusername(username);
        String[] array = null;
        if (list != null && list.size() > 0) {
            array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = list.get(i).getClassid();
            }
        }
        return array;
    }

    private boolean isExist(String classid, String classname) {
        Mailclass mc = new Mailclass();
        mc.setClassid(classid);
        List<Mailclass> list = this.queryMailclass(mc);
        if (list.size() > 0) {
            return true;
        }
        mc.setClassid("");
        mc.setClassname(classname);
        list = this.queryMailclass(mc);
        return list.size() > 0;
    }

    private boolean isExistClassNameButNoClassid(String classname, String classid) {
        Mailclass mc = new Mailclass();
        mc.setClassname(classname);
        List<Mailclass> list = this.queryMailclass(mc);
        if (list.size() > 0) {
            for (Mailclass m : list) {
                if (m.getClassid().equals(classid)) continue;
                return true;
            }
        }
        return false;
    }
}

