/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.util;

import com.xunlei.channel.util.PropertiesReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VIPNumberUtil {
    private static Map<String, String> uRLConfigMap = new HashMap<String, String>();
    private static PropertiesReader pu;
    private static Log logger;

    private static void loadVIPConfig() {
        try {
            uRLConfigMap.put("tianjin_main_server_host", pu.getProperty("tianjin_main_server_host"));
            uRLConfigMap.put("tianjin_main_server_port", pu.getProperty("tianjin_main_server_port"));
            uRLConfigMap.put("tianjin_main_server_timeout", pu.getProperty("tianjin_main_server_timeout"));
            uRLConfigMap.put("tianjin_backup_server_host", pu.getProperty("tianjin_backup_server_host"));
            uRLConfigMap.put("tianjin_backup_server_port", pu.getProperty("tianjin_backup_server_port"));
            uRLConfigMap.put("tianjin_backup_server_timeout", pu.getProperty("tianjin_backup_server_timeout"));
            uRLConfigMap.put("shenzhen_backup_server_host", pu.getProperty("shenzhen_backup_server_host"));
            uRLConfigMap.put("shenzhen_backup_server_port", pu.getProperty("shenzhen_backup_server_port"));
            uRLConfigMap.put("shenzhen_backup_server_timeout", pu.getProperty("shenzhen_backup_server_timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void loadXlnumbetConfig() {
        try {
            uRLConfigMap.put("lianghao_server_host", pu.getProperty("lianghao_server_host"));
            uRLConfigMap.put("lianghao_server_port", pu.getProperty("lianghao_server_port"));
            uRLConfigMap.put("lianghao_server_timeout", pu.getProperty("lianghao_server_timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getURLPart(int type) {
        String host = "";
        String port = "";
        String urlPart = "";
        switch (type) {
            case 1: {
                host = uRLConfigMap.get("tianjin_main_server_host");
                logger.info("host : " + host);
                port = uRLConfigMap.get("tianjin_main_server_port");
                break;
            }
            case 2: {
                host = uRLConfigMap.get("tianjin_backup_server_host");
                port = uRLConfigMap.get("tianjin_backup_server_port");
                break;
            }
            case 3: {
                host = uRLConfigMap.get("shenzhen_backup_server_host");
                port = uRLConfigMap.get("shenzhen_backup_server_port");
                break;
            }
            default: {
                try {
                    throw new Exception("");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        urlPart = "http://" + host + ":" + port + "/";
        logger.info("urlPart : " + urlPart);
        return urlPart;
    }

    private static String getVIPUrl(String userId, int type) {
        String urlPart = VIPNumberUtil.getURLPart(type);
        String url = null;
        url = urlPart + "cache?userid=" + userId;
        logger.info("VIP URL=:  " + url);
        return url;
    }

    private static String getXlnumberUrl(String xlnumber) {
        String urlString = null;
        String urlPart = "http://" + uRLConfigMap.get("lianghao_server_host") + ":" + uRLConfigMap.get("lianghao_server_port") + "/";
        urlString = urlPart + "xlnumber?xlgn_cache_get_info=" + xlnumber;
        logger.info("XLNumber URL=:  " + urlString);
        return urlString;
    }

    private static Map<String, String> getVIPBackInfoMap(String userId, int type, String splitString) {
        String retXml = "";
        HttpURLConnection httpURLConnection = null;
        String timeout = null;
        String url = null;
        HashMap<String, String> backMap = new HashMap();
        try {
            url = VIPNumberUtil.getVIPUrl(userId, 1);
            timeout = uRLConfigMap.get("tianjin_main_server_timeout");
            URL urlConnect = new URL(url);
            httpURLConnection = (HttpURLConnection)urlConnect.openConnection();
            httpURLConnection.setConnectTimeout(Integer.valueOf(timeout));
            BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                retXml = retXml + line;
            }
            in.close();
            logger.info("retXml=" + retXml);
            backMap = VIPNumberUtil.parseMap(retXml, splitString);
            return backMap;
        }
        catch (Exception e) {
            try {
                url = VIPNumberUtil.getVIPUrl(userId, 2);
                timeout = uRLConfigMap.get("tianjin_backup_server_timeout");
                URL urlConnect = new URL(url);
                httpURLConnection = (HttpURLConnection)urlConnect.openConnection();
                httpURLConnection.setConnectTimeout(Integer.valueOf(timeout));
                BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                String line = null;
                while ((line = in.readLine()) != null) {
                    retXml = retXml + line;
                }
                in.close();
                logger.info("retXml=" + retXml);
                backMap = VIPNumberUtil.parseMap(retXml, splitString);
                return backMap;
            }
            catch (Exception e2) {
                try {
                    url = VIPNumberUtil.getVIPUrl(userId, 3);
                    timeout = uRLConfigMap.get("shenzhen_backup_server_timeout");
                    URL urlConnect = new URL(url);
                    httpURLConnection = (HttpURLConnection)urlConnect.openConnection();
                    httpURLConnection.setConnectTimeout(Integer.valueOf(timeout));
                    BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        retXml = retXml + line;
                    }
                    in.close();
                    logger.info("retXml=" + retXml);
                    backMap = VIPNumberUtil.parseMap(retXml, splitString);
                    return backMap;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    return null;
                }
            }
        }
    }

    private static List<String> getXlnumberBackInfoList(String xlnumber, String splitString) {
        String retXml = "";
        HttpURLConnection httpURLConnection = null;
        String timeout = uRLConfigMap.get("lianghao_server_timeout");
        String url = null;
        ArrayList<String> backList = null;
        url = VIPNumberUtil.getXlnumberUrl(xlnumber);
        try {
            URL urlConnect = new URL(url);
            httpURLConnection = (HttpURLConnection)urlConnect.openConnection();
            httpURLConnection.setConnectTimeout(Integer.valueOf(timeout));
            BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                retXml = retXml + line;
            }
            in.close();
            logger.info("retXml: " + retXml);
            String[] resultStrings = retXml.split(splitString);
            backList = new ArrayList<String>(11);
            for (int i = 0; i < resultStrings.length; ++i) {
                backList.add(i, resultStrings[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return backList;
    }

    private static Map<String, String> parseMap(String retxml, String splitString) {
        ArrayList<String> resultList = new ArrayList<String>();
        HashMap<String, String> backMap = new HashMap<String, String>();
        try {
            String[] resultStrings = retxml.split(splitString);
            resultList = new ArrayList(resultStrings.length);
            for (int i = 0; i < resultStrings.length; ++i) {
                resultList.add(i, resultStrings[i]);
            }
            for (String indexString : resultList) {
                backMap.put(indexString.split("=")[0], indexString.split("=")[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return backMap;
    }

    public static Map<String, String> getVIPInfoMap(String userId) {
        Map<String, String> resultMap = VIPNumberUtil.getVIPBackInfoMap(userId, 1, "&");
        return resultMap;
    }

    public static List<String> getXlnumberInfoList(String xlnumber) {
        List<String> resultList = VIPNumberUtil.getXlnumberBackInfoList(xlnumber, ",");
        return resultList;
    }

    public static Map<String, String> getVipInfoMap(String userid, String sessionId) {
        return VIPNumberUtil.getVIPInfoMap(userid, true, sessionId, 1, "&");
    }

    private static Map<String, String> getVIPInfoMap(String userId, boolean secure, String sessionid, int type, String splitString) {
        String retXml = "";
        HttpURLConnection httpURLConnection = null;
        String timeout = null;
        String url = null;
        HashMap<String, String> backMap = new HashMap();
        try {
            url = VIPNumberUtil.getVIPInfoUrl(1, userId, secure, sessionid);
            timeout = uRLConfigMap.get("tianjin_main_server_timeout");
            URL urlConnect = new URL(url);
            httpURLConnection = (HttpURLConnection)urlConnect.openConnection();
            httpURLConnection.setConnectTimeout(Integer.valueOf(timeout));
            BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                retXml = retXml + line;
            }
            in.close();
            logger.info("retXml=" + retXml);
            backMap = VIPNumberUtil.parseMap(retXml, splitString);
            return backMap;
        }
        catch (Exception e) {
            try {
                url = VIPNumberUtil.getVIPInfoUrl(2, userId, secure, sessionid);
                timeout = uRLConfigMap.get("tianjin_backup_server_timeout");
                URL urlConnect = new URL(url);
                httpURLConnection = (HttpURLConnection)urlConnect.openConnection();
                httpURLConnection.setConnectTimeout(Integer.valueOf(timeout));
                BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                String line = null;
                while ((line = in.readLine()) != null) {
                    retXml = retXml + line;
                }
                in.close();
                logger.info("retXml=" + retXml);
                backMap = VIPNumberUtil.parseMap(retXml, splitString);
                return backMap;
            }
            catch (Exception e2) {
                try {
                    url = VIPNumberUtil.getVIPInfoUrl(3, userId, secure, sessionid);
                    timeout = uRLConfigMap.get("shenzhen_backup_server_timeout");
                    URL urlConnect = new URL(url);
                    httpURLConnection = (HttpURLConnection)urlConnect.openConnection();
                    httpURLConnection.setConnectTimeout(Integer.valueOf(timeout));
                    BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        retXml = retXml + line;
                    }
                    in.close();
                    logger.info("retXml=" + retXml);
                    backMap = VIPNumberUtil.parseMap(retXml, splitString);
                    return backMap;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    return null;
                }
            }
        }
    }

    private static String getVIPInfoUrl(int type, String userId, boolean secure, String sessionid) {
        String urlPart = VIPNumberUtil.getURLPart(type);
        String url = null;
        url = urlPart + "cache?userid=" + userId + "&secure=" + secure + "&sessionid=" + sessionid;
        logger.info("VIP URL=:  " + url);
        return url;
    }

    static {
        logger = LogFactory.getLog(VIPNumberUtil.class);
        try {
            pu = new PropertiesReader("xlchannelusersrv.properties");
            VIPNumberUtil.loadVIPConfig();
            VIPNumberUtil.loadXlnumbetConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

