/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.servlet;

import ch.qos.logback.access.servlet.TeeHttpServletRequest;
import ch.qos.logback.access.servlet.TeeHttpServletResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeeFilter
implements Filter {
    boolean active;

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.active && request instanceof HttpServletRequest) {
            try {
                TeeHttpServletRequest teeRequest = new TeeHttpServletRequest((HttpServletRequest)request);
                TeeHttpServletResponse teeResponse = new TeeHttpServletResponse((HttpServletResponse)response);
                filterChain.doFilter(teeRequest, teeResponse);
                teeResponse.finish();
                teeRequest.setAttribute("LB_OUTPUT_BUFFER", teeResponse.getOutputBuffer());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            catch (ServletException e) {
                e.printStackTrace();
                throw e;
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String includeListAsStr = filterConfig.getInitParameter("includes");
        String excludeListAsStr = filterConfig.getInitParameter("excludes");
        String localhostName = TeeFilter.getLocalhostName();
        this.active = TeeFilter.computeActivation(localhostName, includeListAsStr, excludeListAsStr);
        if (this.active) {
            System.out.println("TeeFilter will be ACTIVE on this host [" + localhostName + "]");
        } else {
            System.out.println("TeeFilter will be DISABLED on this host [" + localhostName + "]");
        }
    }

    static List<String> extractNameList(String nameListAsStr) {
        String[] nameArray;
        ArrayList<String> nameList = new ArrayList<String>();
        if (nameListAsStr == null) {
            return nameList;
        }
        if ((nameListAsStr = nameListAsStr.trim()).length() == 0) {
            return nameList;
        }
        for (String n : nameArray = nameListAsStr.split("[,;]")) {
            n = n.trim();
            nameList.add(n);
        }
        return nameList;
    }

    static String getLocalhostName() {
        String hostname = "127.0.0.1";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        return hostname;
    }

    static boolean computeActivation(String hostname, String includeListAsStr, String excludeListAsStr) {
        List<String> includeList = TeeFilter.extractNameList(includeListAsStr);
        List<String> excludeList = TeeFilter.extractNameList(excludeListAsStr);
        boolean inIncludesList = TeeFilter.mathesIncludesList(hostname, includeList);
        boolean inExcludesList = TeeFilter.mathesExcludesList(hostname, excludeList);
        return inIncludesList && !inExcludesList;
    }

    static boolean mathesIncludesList(String hostname, List<String> includeList) {
        if (includeList.isEmpty()) {
            return true;
        }
        return includeList.contains(hostname);
    }

    static boolean mathesExcludesList(String hostname, List<String> excludesList) {
        if (excludesList.isEmpty()) {
            return false;
        }
        return excludesList.contains(hostname);
    }
}

