package com.xunyi.env;


import com.google.common.collect.Maps;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class StandardEnvironment extends AbstractEnvironment {


    protected void customizePropertySources(MutablePropertySources propertySources) {
        InputStream in = this.getClass().getResourceAsStream("/env.properties");
        if (in != null) {
            load(propertySources, in);
        }
        InputStream applicationIn = this.getClass().getResourceAsStream("/application.properties");
        if (applicationIn != null) {
            load(propertySources, applicationIn);
        }
        String env = getProperty("env");
        InputStream envIn = this.getClass().getResourceAsStream(String.format("/%s/application.properties", env));
        if (envIn != null) {
            load(propertySources, envIn);
        }
    }

    private void load(MutablePropertySources propertySources, InputStream in) {
        try {
            if (in != null) {
                Properties envProps = new Properties();
                envProps.load(in);
                Map<String, Object> properties = Maps.newHashMap();
                for (Object key : envProps.keySet()) {
                    String keyString = (String) key;
                    String value = envProps.getProperty(keyString);
                    properties.put(keyString, value);
                }

                MapPropertySource propertySource = new MapPropertySource("env", properties);
                propertySources.addLast(propertySource);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (in != null) in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
