package com.xunyi.env;

public abstract class PropertySource<T> {

    protected final String name;

    protected final T source;

    protected PropertySource(String name, T source) {
        this.name = name;
        this.source = source;
    }

    public String getName() {
        return name;
    }

    public T getSource() {
        return source;
    }


    public boolean containsProperty(String name) {
        return (getProperty(name) != null);
    }

    public abstract Object getProperty(String name);



}
