package com.xunyi.env;



public abstract class AbstractEnvironment {


    private final MutablePropertySources propertySources = new MutablePropertySources();

    private final PropertySourcesPropertyResolver propertyResolver =
            new PropertySourcesPropertyResolver(this.propertySources);

    public AbstractEnvironment() {
        customizePropertySources(this.propertySources);
    }


    public String resolvePlaceholders(String text) {
        return this.propertyResolver.resolvePlaceholders(text);
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.propertyResolver.resolveRequiredPlaceholders(text);
    }

    public boolean containsProperty(String key) {
        return this.propertyResolver.containsProperty(key);
    }

    public String getProperty(String key) {
        return this.propertyResolver.getProperty(key);
    }


    public String getProperty(String key, String defaultValue) {
        return this.propertyResolver.getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        return this.propertyResolver.getProperty(key, targetType);
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return this.propertyResolver.getProperty(key, targetType, defaultValue);
    }

    protected void customizePropertySources(MutablePropertySources propertySources) {
    }

}
