/**
 * 
 */
package com.xunlei.netty.util;

import org.apache.commons.lang.StringUtils;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;

/**
 * 埋点监控辅助类
 * 
 * @author wangcanyi
 *
 */
public class MetricsUtil {
	/**
	 * Transaction Sql类型
	 * 
	 * @param name
	 * @return
	 */
	public static Transaction newTransactionSql(String name) {
		Transaction t = null;
		if (StringUtils.isNotBlank(name))
			t = Cat.newTransaction("SQL", name);
		return t;
	}
	/**
	 * Transaction Cache类型
	 * 
	 * @param name
	 * @return
	 */
	public static Transaction newTransactionCache(String name) {
		Transaction t = null;
		if (StringUtils.isNotBlank(name))
			t = Cat.newTransaction("Cache", name);
		return t;
	}
	/**
	 * Transaction Other类型
	 * 
	 * @param name
	 * @return
	 */
	public static Transaction newTransactionOther(String name) {
		Transaction t = null;
		if (StringUtils.isNotBlank(name))
			t = Cat.newTransaction("Other", name);
		return t;
	}

	/**
	 * Transaction 成功
	 * 
	 * @param t
	 */
	public static void newTransactionSuccess(Transaction t) {
		if (t != null) {
			t.setStatus(Transaction.SUCCESS);
			t.complete();
		}
	}

	/**
	 * Transaction 失败
	 * 
	 * @param t
	 * @param e
	 */
	public static void newTransactionError(Transaction t, Throwable e) {
		if (t != null) {
			t.setStatus(e);
			t.complete();
		}
	}
}