/**
 * 
 */
package com.xunlei.netty.util;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang.StringUtils;
import org.apache.http.protocol.HTTP;

import com.sun.net.httpserver.HttpContext;

/**
 * Html生成辅助类
 * @author wangcanyi
 *
 */
public class HtmlUtil {
	private static StringBuilder htmlTemplate = HtmlUtil.getHtmlTemplate();
	/**
	 * Html模板
	 * @return
	 */
	private static StringBuilder getHtmlTemplate(){
		if(htmlTemplate == null){
			htmlTemplate = new StringBuilder();
			htmlTemplate.append("<!DOCTYPE html>");
			htmlTemplate.append("<html lang='zh-CN'>");
			htmlTemplate.append("  <head>");
			htmlTemplate.append("    <meta charset='utf-8'>");
			htmlTemplate.append("    <meta http-equiv='X-UA-Compatible' content='IE=edge'>");
			htmlTemplate.append("    <meta name='viewport' content='width=device-width, initial-scale=1'>");
			htmlTemplate.append("    <!-- Bootstrap -->");
			htmlTemplate.append("	<!-- 新 Bootstrap 核心 CSS 文件 -->");
			htmlTemplate.append("	<link rel='stylesheet' href='http://cdn.bootcss.com/bootstrap/3.3.5/css/bootstrap.min.css'>");
			htmlTemplate.append("    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->");
			htmlTemplate.append("    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->");
			htmlTemplate.append("    <!--[if lt IE 9]>");
			htmlTemplate.append("      <script src='//cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js'></script>");
			htmlTemplate.append("      <script src='//cdn.bootcss.com/respond.js/1.4.2/respond.min.js'></script>");
			htmlTemplate.append("    <![endif]-->");
			htmlTemplate.append("  </head>");
			htmlTemplate.append("  <body>");
			htmlTemplate.append("	{body}");
			htmlTemplate.append("  </body>");
			htmlTemplate.append("</html>");
		}
		return htmlTemplate;
	}
	/**
	 * 生成Html表格,List里的Map的Key，必须完全一致，包括个数与KeyName
	 * @return
	 */
	public static String getHtmlTable(List<Map<String,String>> tableData){
		StringBuilder htmlTable = new StringBuilder();
		if(tableData!= null && tableData.size() > 0){
			htmlTable.append("<table class='table table-hover'>");
			//列名
			htmlTable.append("<thead>");
			htmlTable.append("<tr>");
			htmlTable.append("<th>#</th>");
			for (String keyName : tableData.get(0).keySet()) {
				htmlTable.append("<th>").append(keyName).append("</th>");
			}
			htmlTable.append("</tr>");
			htmlTable.append("</thead>");
			//列数据
			htmlTable.append("<tbody>");
			for (Map<String, String> mapData : tableData) {
				htmlTable.append("<tr>");
				htmlTable.append("<th scope='row'>").append(tableData.indexOf(mapData) + 1).append("</th>");
				for (Entry<String, String> map : mapData.entrySet()) {
					htmlTable.append("<td>").append(map.getValue()).append("</td>");
				}
				htmlTable.append("</tr>");
			}
			htmlTable.append("</tbody>");
			htmlTable.append("</table>");
		}
		return StringUtils.replace(htmlTemplate.toString(), "{body}", htmlTable.toString());
	}
	
	/**
	 * 获取a标签
	 * @param name
	 * @param url
	 * @return
	 */
	public static String getHtmlLink(String name,String url){
		String html = "<a href='{url}' target='_blank'>{name}</a></td>";
		return html.replace("{name}", name).replace("{url}", url);
	}
	/**
	 * 获取a标签，显示名与链接一样
	 * @param url
	 * @return
	 */
	public static String getHtmlLink(String url){
		return getHtmlLink(url,url);
	}
	
	/**
	 * 获取Form表单
	 * @param formContent
	 * @param actionUrl
	 * @return
	 */
	public static String getHtmlForm(String formContent,String actionUrl){
		String html = "<form action='{actionUrl}' method='get'>{formContent}<input class='btn btn-primary' type='submit' value='提交 '/></form>";
		return html.replace("{formContent}", formContent).replace("{actionUrl}", actionUrl);
	}
	
	/**
	 * 获取单选按钮
	 * @param radioList
	 * @param currrentRadio
	 * @return
	 */
	public static String getHtmlRadio(String radioName, List<String> radioList,String currrentRadio){
		StringBuilder html = new StringBuilder();
		if(radioList != null && radioList.size() > 0){
			for (String string : radioList) {
				html.append("<input type='radio' name='").append(radioName).append("' value='").append(string).append("'");
				if(string.equals(currrentRadio))
					html.append(" checked ");
				html.append(" />");
				html.append(string);
			}
		}
		return html.toString();
	}
	/**
	 * 获取隐藏标签
	 * @param name
	 * @param value
	 * @return
	 */
	public static String getInputHidden(String name,String value){
		String html = "<input type='hidden' name='{name}' value='{value}' />";
		return html.replace("{name}", name).replace("{value}", value);
	}
	/**
	 * 获取文本标签
	 * @param name
	 * @param value
	 * @return
	 */
	public static String getInputText(String name,String value){
		String html = "<input type='text' class='form-control' name='{name}' value='{value}' style='display:inline;width:20%;'/>";
		return html.replace("{name}", name).replace("{value}", value);
	}
}
