/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.slf4j.Logger;

import com.xunlei.netty.grpcserver.client.GRPCClientFactory;
import com.xunlei.netty.soaserver.client.SOAClientFactory;
import com.xunlei.netty.soaserver.cmd.common.ISOACmdService;
import com.xunlei.netty.util.Log;

/**
 * 服务工厂
 * 
 * @author wangcanyi
 *
 */
public class SOAServiceCmdFactory extends SOAServiceBase {
	private static final Logger log = Log.getLogger();
	/**
	 * 服务工厂列表
	 */
	private static List<SOAServiceCmdFactory> soaServiceCmdFactoryList = new ArrayList<SOAServiceCmdFactory>();
	/**
	 * SOA 客户端工厂类
	 */
	private SOAClientFactory soaClientFactory;
	/**
	 * GRPC 客户端工厂类
	 */
	private GRPCClientFactory grpcClientFactory;

	/**
	 * 构造器
	 * 
	 * @param appName 项目名
	 * @param configUrl 配置文件地址（ServiceHost，ServicePort，ConnectionTimeout）
	 */
	public SOAServiceCmdFactory(String appName, String configUrl) {
		super(appName, configUrl);
		this.soaClientFactory = this.newSOAClientFactory();
		SOAServiceCmdFactory.soaServiceCmdFactoryList.add(this);
		this.grpcClientFactory = new GRPCClientFactory(this);
	}

	public SOAServiceCmdFactory(String appName, Properties properties) {
		super(appName, properties);
		this.soaClientFactory = this.newSOAClientFactory();
		SOAServiceCmdFactory.soaServiceCmdFactoryList.add(this);
		this.grpcClientFactory = new GRPCClientFactory(this);
	}



	private SOAClientFactory newSOAClientFactory() {
		SOAClientFactory soaClient = new SOAClientFactory(this);
		// 初始化接口
		this.soaCmdService = (ISOACmdService) soaClient.getObject(ISOACmdService.class);
		return soaClient;
	}

	/**
	 * 运行RpcOutput
	 * 
	 * @param rpcOutput RpcOutput
	 * @return
	 * @throws Exception
	 */
	public Object invokeRpcOutput(RpcOutput rpcOutput) throws Exception {
		return this.soaClientFactory.newInterfaceProxyBase(null).invoke(rpcOutput);
	}

	private ISOACmdService soaCmdService;

	/**
	 * @return 获取SOA客户端工厂
	 */
	protected SOAClientFactory getSoaClientFactory() {
		return soaClientFactory;
	}

	/**
	 * @return 获取GRPC客户端工厂
	 */
	public GRPCClientFactory getGrpcClientFactory() {
		return grpcClientFactory;
	}

	/**
	 * @return 底层SOACmd服务
	 */
	public ISOACmdService getSoaCmdService() {
		return soaCmdService;
	}

	/**
	 * @return 服务工厂列表
	 */
	public static List<SOAServiceCmdFactory> getSoaServiceCmdFactoryList() {
		return soaServiceCmdFactoryList;
	}
}
