/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import com.xunlei.netty.soaserver.exception.SOAServerRuntimeException;


/**
 * SOA服务接口响应类
 * 
 * @author wangcanyi
 *
 */
public class SOAResponse<T> extends GenericBase<T> {

	/**
	 * @param genericType 泛型类型
	 */
	public SOAResponse(Class<?> genericType) {
		super(genericType);
		if(genericType == null)
			throw new SOAServerRuntimeException("泛型类型不能为空");
	}

	private int rtn;
	private T data;
	private String msg;

	/**
	 * @return 状态码 0.正常 非0.异常
	 */
	public int getRtn() {
		return rtn;
	}

	/**
	 * @param rtn 状态码 0.正常 非0.异常
	 */
	public void setRtn(int rtn) {
		this.rtn = rtn;
	}

	/**
	 * @return 响应数据，rtn=0时，有值
	 */
	public T getData() {
		return data;
	}

	/**
	 * @param data 响应数据，rtn=0时，有值
	 */
	public void setData(T data) {
		this.data = data;
	}

	/**
	 * @return 错误消息，rtn!=0时，有值
	 */
	public String getMsg() {
		return msg;
	}

	/**
	 * @param msg 错误消息，rtn!=0时，有值
	 */
	public void setMsg(String msg) {
		this.msg = msg;
	}

}
