/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import org.apache.commons.lang.StringUtils;

import com.google.gson.Gson;
import com.xunlei.netty.soaserver.exception.SOAServerRuntimeException;
import com.xunlei.netty.util.SignUtil;
import com.xunlei.netty.util.spring.BeanUtil;

/**
 * Rpc 对象输出
 * 
 * @author wangcanyi
 *
 */
public class RpcOutput extends RpcObjectBase {
	private DTOBase[] methodArgs;
	private String ipAddress;
	private String appName;
	private String rootMessageId;
	private String messageId;
	private String childMessageId;
	private String signMsg;

	/**
	 * @return 方法参数列表
	 */
	public DTOBase[] getMethodArgs() {
		return methodArgs;
	}

	/**
	 * @param methodArgs 方法参数列表
	 */
	public void setMethodArgs(DTOBase[] methodArgs) {
		this.methodArgs = methodArgs;
	}

	/**
	 * @return IP地址
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * @param ipAddress IP地址
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * @return 应用领域名
	 */
	public String getAppName() {
		return appName;
	}

	/**
	 * @param appName 应用领域名
	 */
	public void setAppName(String appName) {
		this.appName = appName;
	}

	/**
	 * @return 根消息Id
	 */
	public String getRootMessageId() {
		return rootMessageId;
	}

	/**
	 * @param rootMessageId 根消息Id
	 */
	public void setRootMessageId(String rootMessageId) {
		this.rootMessageId = rootMessageId;
	}

	/**
	 * @return 消息Id
	 */
	public String getMessageId() {
		return messageId;
	}

	/**
	 * @param messageId 消息Id
	 */
	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	/**
	 * @return 子消息Id
	 */
	public String getChildMessageId() {
		return childMessageId;
	}

	/**
	 * @param childMessageId 子消息Id
	 */
	public void setChildMessageId(String childMessageId) {
		this.childMessageId = childMessageId;
	}

	/**
	 * @return 签名
	 */
	public String getSignMsg() {
		return signMsg;
	}

	/**
	 * @param signMsg 签名
	 */
	public void setSignMsg(String signMsg) {
		this.signMsg = signMsg;
	}

	/**
	 * 设置方法参数
	 * 
	 * @param objectArgs
	 */
	public void setMethodObjectArgs(Object[] objectArgs, String signKey) {
		Gson gson = new Gson();
		if (objectArgs != null && objectArgs.length > 0) {
			methodArgs = new DTOBase[objectArgs.length];
			for (int i = 0; i < objectArgs.length; i++) {
				Object object = objectArgs[i];
				methodArgs[i] = new DTOBase(object);
			}
		}
		if (StringUtils.isNotBlank(signKey)) {// 有签名时进行签名
			String content = "";
			if (methodArgs != null && methodArgs.length > 0)
				content = gson.toJson(methodArgs);
			signMsg = SignUtil.sign(content, signKey);
		}
	}

	/**
	 * 获取方法参数
	 * 
	 * @return
	 * @throws Exception
	 */
	public Object[] getMethodObjectArgs(String signKey) throws Exception {
		Object[] retObjArray = null;
		Gson gson = new Gson();
		if(StringUtils.isNotBlank(signKey)){//有签名时验证签名
			String content = "";
			if (methodArgs != null && methodArgs.length > 0)
				content = gson.toJson(methodArgs);
			String newSignMsg = SignUtil.sign(content, signKey);
			if(StringUtils.isBlank(signMsg))
				throw new SOAServerRuntimeException("签名为空");
			if(!newSignMsg.equals(signMsg))
				throw new SOAServerRuntimeException("签名不一致");
		}
		if (methodArgs != null && methodArgs.length > 0) {
			retObjArray = new Object[methodArgs.length];
			for (int i = 0; i < methodArgs.length; i++) {
				DTOBase arg = methodArgs[i];
				retObjArray[i] = arg.getObject();
			}
		}
		return retObjArray;
	}

	/**
	 * 根据output生成input
	 * 
	 * @param rpcOutput
	 * @return
	 */
	public RpcInput getRpcInput() {
		RpcInput rpcInput = new RpcInput();
		BeanUtil.copyProperties(rpcInput, this);
		return rpcInput;
	}
}
