/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAAdmin;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAMethodAlias;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAMethodAsyn;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAMethodRetry;

/**
 * SOA RPC 对象协议基类
 * 
 * @author wangcanyi
 *
 */
public class RpcObjectBase {

	private String interfaceName;
	private String methodName;
	private String name;
	private String simpleName;
	private String token;
	private String isAsynMethod = Boolean.toString(false);
	private boolean isAdmin = false;
	private int retryCount = 0;

	/**
	 * @return 接口名
	 */
	public String getInterfaceName() {
		return interfaceName;
	}

	/**
	 * @param interfaceName 接口名
	 */
	public void setInterfaceName(String interfaceName) {
		this.interfaceName = interfaceName;
	}

	/**
	 * @return 方法名
	 */
	public String getMethodName() {
		return methodName;
	}

	/**
	 * @param methodName 方法名
	 */
	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	/**
	 * @return 显示名
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name 显示名
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return 简单显示名
	 */
	public String getSimpleName() {
		return simpleName;
	}

	/**
	 * @param simpleName 简单显示名
	 */
	public void setSimpleName(String simpleName) {
		this.simpleName = simpleName;
	}

	/**
	 * @return 令牌
	 */
	public String getToken() {
		return token;
	}

	/**
	 * @param token 令牌
	 */
	public void setToken(String token) {
		this.token = token;
	}

	/**
	 * @return 是否异步方法
	 */
	public String getIsAsynMethod() {
		return isAsynMethod;
	}

	/**
	 * @param isAsynMethod 是否异步方法
	 */
	public void setIsAsynMethod(String isAsynMethod) {
		this.isAsynMethod = isAsynMethod;
	}

	/**
	 * @return 是否管理员接口
	 */
	public boolean isAdmin() {
		return isAdmin;
	}

	/**
	 * @param isAdmin 是否管理员接口
	 */
	public void setAdmin(boolean isAdmin) {
		this.isAdmin = isAdmin;
	}

	/**
	 * @return 重试次数
	 */
	public int getRetryCount() {
		return retryCount;
	}

	/**
	 * @param retryCount 重试次数
	 */
	public void setRetryCount(int retryCount) {
		this.retryCount = retryCount;
	}

	/**
	 * 设置方法信息
	 * 
	 * @param method
	 */
	public void setRpcObject(Class<?> interfaceClass, Method method) {
		if (interfaceClass != null) {
			this.interfaceName = interfaceClass.getName();
		}
		if (method != null) {
			// 方法名
			this.methodName = method.getName();
			// 设置全名
			if (method.getAnnotation(CmdSOAMethodAlias.class) != null) {// 是否有别名
				CmdSOAMethodAlias aliasMethod = method.getAnnotation(CmdSOAMethodAlias.class);
				this.name = this.interfaceName + "." + aliasMethod.value();
				this.simpleName = this.interfaceName + "." + this.methodName + "(Alias:" + aliasMethod.value() + ")";
			} else {
				this.name = this.interfaceName + "." + this.methodName;
				this.simpleName = this.name;
			}
			// 设置token
			this.token = java.util.UUID.randomUUID().toString();
			// 设置是否异步方法
			if (method.getAnnotation(CmdSOAMethodAsyn.class) != null)// 是否异步方法
				this.isAsynMethod = Boolean.toString(true);
			// 是否管理员接口
			if (method.getAnnotation(CmdSOAAdmin.class) != null)// 是否异步方法
				this.isAdmin = true;
			// 设置方法重试次数
			CmdSOAMethodRetry methodRetry = method.getAnnotation(CmdSOAMethodRetry.class);
			if (methodRetry != null) {
				this.retryCount = methodRetry.retryCount();
			}
			// 设置显示名
			String argStr = "";
			if (method.getParameterTypes() != null && method.getParameterTypes().length > 0) {
				List<String> typeNameList = new ArrayList<String>(method.getParameterTypes().length);
				for (Class<?> parType : method.getParameterTypes()) {
					typeNameList.add(parType.getSimpleName());
				}
				argStr = StringUtils.join(typeNameList.toArray(), ", ");
			}
		}
	}
}
