/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

/**
 * 泛型类基类
 * 
 * @author wangcanyi
 *
 */
public abstract class GenericBase<T> {

	private transient Class<?>[] genericType;

	/**
	 * @param genericType 泛型类型
	 */
	public GenericBase(Class<?>... genericType) {
		this.genericType = genericType;
	}

	/**
	 * 获取泛型类型名
	 * 
	 * @return 字符串列表
	 */
	public String[] getGenericTypeString() {
		String[] strArr = null;
		if (this.genericType != null && this.genericType.length > 0) {
			strArr = new String[genericType.length];
			for (int i = 0; i < this.genericType.length; i++) {
				Class<?> type = this.genericType[i];
				strArr[i] = type.getName();
			}
		}
		return strArr;
	}

	/**
	 * 泛型类获取json转换类型
	 * 
	 * @param raw 包装类
	 * @param args T 类型字符串名
	 * @return
	 * @throws Exception
	 */
	public static ParameterizedType getType(final Class raw, final String... args) throws Exception {
		Type[] typeArgs = null;
		if (args != null && args.length > 0) {
			typeArgs = new Type[args.length];
			for (int i = 0; i < args.length; i++) {
				String typeStr = args[i];
				typeArgs[i] = Class.forName(typeStr);
			}
		}
		return getType(raw, typeArgs);
	}

	/**
	 * 泛型类获取json转换类型
	 * 
	 * @param raw 包装类
	 * @param args T 类型
	 * @return
	 */
	public static ParameterizedType getType(final Class raw, final Type... args) {
		return new ParameterizedType() {
			public Type getRawType() {
				return raw;
			}

			public Type[] getActualTypeArguments() {
				return args;
			}

			public Type getOwnerType() {
				return null;
			}
		};
	}

	/**
	 * 获取对象泛型类型
	 * 
	 * @param obj
	 * @return
	 */
	public static String[] getGenericTypeStringByObject(Object obj) {
		String[] strArr = null;
		if (obj instanceof GenericBase) {// 获取泛型类型
			GenericBase<?> benericBase = (GenericBase) obj;
			strArr = benericBase.getGenericTypeString();
		}
		if (obj instanceof List) {// List列表
			List<?> list = (List<?>) obj;
			if (list != null && list.size() > 0) {
				strArr = new String[1];
				strArr[0] = list.get(0).getClass().getName();
			}
		}
		if (obj instanceof Map) {// Map列表
			Map<?, ?> map = (Map<?, ?>) obj;
			if (map != null && map.size() > 0) {
				strArr = new String[2];
				for (Entry<?, ?> kvMap : map.entrySet()) {
					strArr[0] = kvMap.getKey().getClass().getName();
					strArr[1] = kvMap.getValue().getClass().getName();
					break;
				}
			}
		}
		return strArr;
	}
}
