/**
 * 
 */
package com.xunlei.netty.soaserver.cmd.common;

import java.util.List;

import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAAdmin;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAInterface;
import com.xunlei.netty.soaserver.cmd.common.args.SOACmdArg;
import com.xunlei.netty.soaserver.component.RpcOutput;

/**
 * 底层SOACmd服务
 * 
 * @author wangcanyi
 *
 */
@CmdSOAInterface
public interface ISOACmdService {
	/**
	 * 查询SOACmd接口信息
	 * @param arg
	 * @return
	 * @throws Exception
	 */
	@CmdSOAAdmin
	List<RpcOutput> findSOACmd(SOACmdArg arg) throws Exception;

	/**
	 * 获取SOACmd接口，根据唯一名
	 * @param name 唯一名
	 * @return
	 * @throws Exception
	 */
	@CmdSOAAdmin
	RpcOutput getSOACmd(String name) throws Exception;
}
