/**
 * 
 */
package com.xunlei.netty.soaserver.cmd;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAInterface;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.spring.BeanUtil;
import com.xunlei.netty.util.spring.SpringBootstrap;

/**
 * SOA接口映射处理
 * 
 * @author wangcanyi
 *
 */
@Component
public class CmdSOAMappers {
	private static final Logger log = Log.getLogger();
	/**
	 * 所有接口映射CmdMeta
	 */
	private Map<String, CmdSOAMeta> cmdAllMap = new LinkedHashMap<String, CmdSOAMeta>();

	/**
	 * 获取CMD类
	 * 
	 * @param name
	 * @return
	 */
	private BaseSOACmd getCmd(String name) {
		Object obj = BeanUtil.getTypedBean(name);
		if (obj instanceof BaseSOACmd) {
			Class<?> clazz = obj.getClass();
			if (clazz.getAnnotation(Deprecated.class) != null) {
				return null;
			}
			return (BaseSOACmd) obj;
		}
		return null;
	}

	/**
	 * 获取所有的CMD
	 * 
	 * @return
	 */
	private List<BaseSOACmd> getCmds() {
		List<BaseSOACmd> cmdList = new ArrayList<BaseSOACmd>();
		for (String name : SpringBootstrap.getContext().getBeanDefinitionNames()) {
			BaseSOACmd cmd = getCmd(name);
			if (cmd != null) {
				cmdList.add(cmd);
			}
		}
		return cmdList;
	}

	/**
	 * 初始化SOA接口
	 * 
	 * @return
	 * @throws Exception
	 */
	public Map<String, CmdSOAMeta> initInterfaceMap() throws Exception {
		Map<String, CmdSOAMeta> tmpMeta = new LinkedHashMap<String, CmdSOAMeta>();
		for (BaseSOACmd cmd : getCmds()) {
			Class<?> clazz = cmd.getClass();
			Class<?>[] interfaceArray = clazz.getInterfaces();
			if (interfaceArray != null && interfaceArray.length > 0) {
				for (Class<?> interfaceClass : interfaceArray) {
					if (interfaceClass.getAnnotation(CmdSOAInterface.class) == null)// 需要含有SOA接口标记
						continue;
					Method[] interfaceMethodArray = interfaceClass.getMethods();
					if (interfaceMethodArray != null && interfaceMethodArray.length > 0) {
						for (Method method : interfaceMethodArray) {
							if (!Modifier.isPublic(method.getModifiers()))// 非公开方法，不进行服务化
								continue;
							CmdSOAMeta soaMeta = new CmdSOAMeta(cmd, method, interfaceClass);
							if (tmpMeta.containsKey(soaMeta.getRpcObjectBase().getName()))
								throw new Exception("Duplicate soa function:" + soaMeta.getRpcObjectBase().getName());
							tmpMeta.put(soaMeta.getRpcObjectBase().getName(), soaMeta);
						}
					}
				}
			}
		}
		cmdAllMap.putAll(tmpMeta);
		log.debug("Netty服务.SOA接口映射.{}", tmpMeta);
		return cmdAllMap;
	}

	/**
	 * 获取SOA接口，处理信息
	 * 
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public CmdSOAMeta getCmdSOAMeta(String name) throws Exception {
		CmdSOAMeta meta = cmdAllMap.get(name);
		return meta;
	}
	/**
	 * @return 所有接口映射CmdMeta
	 */
	public Map<String, CmdSOAMeta> getCmdAllMap() {
		return cmdAllMap;
	}

}
