/**
 * 
 */
package com.xunlei.netty.soaserver.client;

import java.lang.reflect.Proxy;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

import com.xunlei.netty.soaserver.component.SOAServiceBase;

/**
 * SOA 客户端工厂类
 * 
 * @author wangcanyi
 *
 */
@SuppressWarnings("rawtypes")
public class SOAClientFactory implements FactoryBean, InitializingBean {

	private Class serviceInterface;// 服务接口
	private SOAServiceBase serviceBase;

	/**
	 * 构造器
	 * @param serviceBase 服务基类
	 */
	public SOAClientFactory(SOAServiceBase serviceBase) {
		this.serviceBase = serviceBase;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		// TODO Auto-generated method stub
	}

	@Override
	public Object getObject() throws Exception {
		return this.getProxyInstance(this.serviceInterface);
	}

	/**
	 * 获取代理类
	 * 
	 * @param serviceInterface
	 * @return
	 */
	public Object getObject(Class serviceInterface) {
		return this.getProxyInstance(serviceInterface);
	}

	/**
	 * 创建代理类
	 * 
	 * @param serviceInterface
	 * @return
	 */
	private Object getProxyInstance(Class serviceInterface) {
		InterfaceProxyBase proxyBase = this.newInterfaceProxyBase(serviceInterface);
		return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[] { serviceInterface }, proxyBase);
	}

	/**
	 * 创建接口动态代理基类
	 * 
	 * @param serviceInterface
	 * @return
	 */
	public InterfaceProxyBase newInterfaceProxyBase(Class serviceInterface) {
		return new InterfaceProxyBase(this.serviceBase, serviceInterface);
	}

	@Override
	public Class getObjectType() {
		return this.getServiceInterface();
	}

	@Override
	public boolean isSingleton() {
		return true;
	}

	/**
	 * @return 服务接口
	 */
	public Class getServiceInterface() {
		return serviceInterface;
	}

	/**
	 * @param serviceInterface 服务接口
	 */
	public void setServiceInterface(Class serviceInterface) {
		this.serviceInterface = serviceInterface;
	}
}
