package com.xunlei.netty.httpserver.cmd.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xunlei.netty.cache.JRedisProxy;
import com.xunlei.netty.consul.ConsulFactory;
import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.cmd.CmdMappers.CmdMeta;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.component.XLHttpResponse.ContentType;
import com.xunlei.netty.soaserver.cmd.CmdSOAMappers;
import com.xunlei.netty.soaserver.cmd.CmdSOAMeta;
import com.xunlei.netty.util.HtmlUtil;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.HttpUtil;
import com.xunlei.netty.util.IPAuthenticator;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.spring.Config;
import com.xunlei.netty.util.spring.ConfigBeanPostProcessor;

/**
 * 实时设置
 * 
 * @author ZengDong
 * @since 2010-5-23 上午12:15:48
 */
@SuppressWarnings("restriction")
@Service
public class SettingCmd extends BaseStatCmd {

	private static final Logger log = Log.getLogger();
	@Autowired
	private CmdMappers cmdMappers;
	@Autowired
	private CmdSOAMappers cmdSOAMappers;
	@Autowired
	private NettyServerConfig config;
	@Autowired
	private ConfigBeanPostProcessor configProcessor;
	@Resource
	private HttpServerPipelineFactory httpServerPipelineFactory;

	/**
	 * <pre>
	 * 服务器的所有接口都不被爬虫收录
	 * 详情见：http://www.baidu.com/search/robots.html
	 * </pre>
	 */
	@CmdMapper("/robots.txt")
	@CmdAdmin
	public Object robots(XLHttpRequest request, XLHttpResponse response) throws Exception {
		response.setInnerContentType(ContentType.plain);
		return "User-agent: *\nDisallow: /\n";
	}

	/**
	 * <pre>
	 * setting/cmds 统计各个接口请求量数据
	 * txt 参数为true表示文本展示统计信息
	 * last 参数为true表示显示最近10分钟内的请求数据
	 * order 参数为true表示根据请求量all_num进行排序显示
	 * </pre>
	 */
	@CmdAdmin
	public Object cmds(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		boolean useTxt = request.getParameterBoolean("txt", false);
		if (!useTxt) {
			response.setInnerContentType(ContentType.html);
		}
		String tmp = "";
		List<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
		Map<String, String> mapData = new LinkedHashMap<String, String>();
		mapData.put("接口类型", "管理员接口");
		mapData.put("地址", HtmlUtil.getHtmlLink("/setting/cmdsAdmain"));
		tableData.add(mapData);
		Map<String, String> mapData1 = new LinkedHashMap<String, String>();
		mapData1.put("接口类型", "HTTP接口");
		mapData1.put("地址", HtmlUtil.getHtmlLink("/setting/cmdsHTTP"));
		tableData.add(mapData1);
		Map<String, String> mapData2 = new LinkedHashMap<String, String>();
		mapData2.put("接口类型", "SOA接口");
		mapData2.put("地址", HtmlUtil.getHtmlLink("/setting/cmdsSOA"));
		tableData.add(mapData2);
		tmp = HtmlUtil.getHtmlTable(tableData);
		return tmp;
	}

	/**
	 * 管理员接口
	 * 
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@CmdAdmin
	public Object cmdsAdmain(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		boolean useTxt = request.getParameterBoolean("txt", false);
		if (!useTxt) {
			response.setInnerContentType(ContentType.html);
		}
		String tmp = "";
		Map<String, CmdMeta> cmd_urls_map = cmdMappers.getCmdAllMap();
		if (cmd_urls_map != null && cmd_urls_map.size() > 0) {
			List<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
			for (Entry<String, CmdMeta> cmdUrlMap : cmd_urls_map.entrySet()) {
				String cmdUrl = cmdUrlMap.getKey();
				CmdMeta cmdMeta = cmdUrlMap.getValue();
				if (cmdMeta.isAdmin()) {
					Map<String, String> mapData = new LinkedHashMap<String, String>();
					mapData.put("url", HtmlUtil.getHtmlLink(cmdUrl));
					mapData.put("name", cmdMeta.toString());
					mapData.put("isAdmin", String.valueOf(cmdMeta.isAdmin()));
					mapData.put("timeout", String.valueOf(cmdMeta.getTimeout()));
					tableData.add(mapData);
				}
			}
			tmp = HtmlUtil.getHtmlTable(tableData);
		}
		return tmp;
	}

	/**
	 * HTTP接口
	 * 
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@CmdAdmin
	public Object cmdsHTTP(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		boolean useTxt = request.getParameterBoolean("txt", false);
		if (!useTxt) {
			response.setInnerContentType(ContentType.html);
		}
		String tmp = "";
		Map<String, CmdMeta> cmd_urls_map = cmdMappers.getCmdAllMap();
		if (cmd_urls_map != null && cmd_urls_map.size() > 0) {
			List<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
			for (Entry<String, CmdMeta> cmdUrlMap : cmd_urls_map.entrySet()) {
				String cmdUrl = cmdUrlMap.getKey();
				CmdMeta cmdMeta = cmdUrlMap.getValue();
				if (!cmdMeta.isAdmin()) {
					Map<String, String> mapData = new LinkedHashMap<String, String>();
					mapData.put("url", HtmlUtil.getHtmlLink(cmdUrl));
					mapData.put("name", cmdMeta.toString());
					mapData.put("isAdmin", String.valueOf(cmdMeta.isAdmin()));
					mapData.put("timeout", String.valueOf(cmdMeta.getTimeout()));
					tableData.add(mapData);
				}
			}
			tmp = HtmlUtil.getHtmlTable(tableData);
		}
		return tmp;
	}

	/**
	 * SOA接口
	 * 
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@CmdAdmin
	public Object cmdsSOA(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		boolean useTxt = request.getParameterBoolean("txt", false);
		if (!useTxt) {
			response.setInnerContentType(ContentType.html);
		}
		String tmp = "";
		Map<String, CmdSOAMeta> cmd_soa_map = cmdSOAMappers.getCmdAllMap();
		if (cmd_soa_map != null && cmd_soa_map.size() > 0) {
			List<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
			for (Entry<String, CmdSOAMeta> cmdUrlMap : cmd_soa_map.entrySet()) {
				String cmdSOA = cmdUrlMap.getKey();
				CmdSOAMeta cmdMeta = cmdUrlMap.getValue();
				Map<String, String> mapData = new LinkedHashMap<String, String>();
				mapData.put("SimpleName", cmdMeta.getRpcObjectBase().getSimpleName());
				mapData.put("IsAsynMethod", String.valueOf(cmdMeta.getRpcObjectBase().getIsAsynMethod()));
				tableData.add(mapData);
			}
			tmp = HtmlUtil.getHtmlTable(tableData);
		}
		return tmp;
	}

	/**
	 * 显示调参的历史记录
	 */
	@CmdAdmin
	public Object configHistory(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		StringBuilder tmp = new StringBuilder();
		return tmp.append(configProcessor.getResetHistory());
	}

	/**
	 * 显示配置信息
	 */
	@CmdAdmin
	public Object config(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		response.setInnerContentType(ContentType.html);
		List<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
		String tmp = "";
		// NettyServerConfig 配置信息
		for (Field f : config.getClass().getDeclaredFields()) {
			if (Modifier.isStatic(f.getModifiers())) {
				continue;
			}
			f.setAccessible(true);
			Map<String, String> mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", f.getName());
			String configValueText = String.valueOf(f.get(config));
			if (f.getAnnotation(Config.class) != null) {
				Config fieldConfig = f.getAnnotation(Config.class);
				if (fieldConfig.resetable()) {
					String input = HtmlUtil.getInputText(f.getName(), String.valueOf(f.get(config)));
					configValueText = HtmlUtil.getHtmlForm(input, "/setting/setConfig");
				}
			}
			mapData.put("ConfigValue", configValueText);
			tableData.add(mapData);
		}
		// IP信息
		Map<String, String> mapData = new LinkedHashMap<String, String>();
		mapData.put("ConfigKey", "本地IP");
		mapData.put("ConfigValue", HttpUtil.getLocalIP() + "");
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("ConfigKey", "IP白名单");
		mapData.put("ConfigValue", IPAuthenticator.getIPWhiteList());
		tableData.add(mapData);
		// JRedisProxy配置信息
		if (JRedisProxy.getInstance() != null) {
			JRedisProxy jRedisProxy = JRedisProxy.getInstance();
			mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", "JRedis配置文件地址[JRedisProxy.jredisPropertiesUrl]");
			mapData.put("ConfigValue", jRedisProxy.getJredisPropertiesUrl());
			tableData.add(mapData);
			mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", "JRedis服务地址[JRedisProxy.ServerHost]");
			mapData.put("ConfigValue", jRedisProxy.getServerHost());
			tableData.add(mapData);
			mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", "JRedis服务端口[JRedisProxy.ServerPort]");
			mapData.put("ConfigValue", jRedisProxy.getServerPort() + "");
			tableData.add(mapData);
			mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", "JRedis服务超时时间[JRedisProxy.ServerTimeout]");
			mapData.put("ConfigValue", jRedisProxy.getServerTimeout() + "");
			tableData.add(mapData);
			mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", "JRedis最大连接数[JRedisProxy.MaxTotal]");
			mapData.put("ConfigValue", jRedisProxy.getMaxTotal() + "");
			tableData.add(mapData);
			mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", "JRedis最大空闲连接数[JRedisProxy.MaxIdle]");
			mapData.put("ConfigValue", jRedisProxy.getMaxIdle() + "");
			tableData.add(mapData);
			mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", "JRedis获取连接时的最大等待毫秒数[JRedisProxy.MaxWaitMillis]");
			mapData.put("ConfigValue", jRedisProxy.getMaxWaitMillis() + "");
			tableData.add(mapData);
		}
		// Consul服务配置信息
		mapData = new LinkedHashMap<String, String>();
		mapData.put("ConfigKey", "Consul.agentHost");
		mapData.put("ConfigValue", ConsulFactory.getInstance().getAgentHost());
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("ConfigKey", "Consul.agentPort");
		mapData.put("ConfigValue", ConsulFactory.getInstance().getAgentPort() + "");
		tableData.add(mapData);

		tmp = HtmlUtil.getHtmlTable(tableData);
		return tmp;
	}

	/**
	 * 重加载config
	 */
	@CmdAdmin
	public Object reloadConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		StringBuilder tmp = new StringBuilder();
		configProcessor.reloadConfig(tmp);
		return tmp.toString();
	}

	/**
	 * 重加载所有命令的设置
	 */
	@CmdAdmin
	public Object reloadCmdConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		// return cmdMappers.resetCmdConfig();
		return null;
	}

	/**
	 * 重加载ipfilter
	 */
	@CmdAdmin
	public Object reloadIpfilter(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		IPAuthenticator.reload();
		return "reset success";
	}

	/**
	 * 重置受临时调参保护的config
	 */
	@CmdAdmin
	public Object resetGuardedConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		StringBuilder tmp = new StringBuilder("reset guarded config...\n");
		configProcessor.resetGuradedConfig(tmp);
		return tmp;
	}

	/**
	 * 临时调参
	 */
	@CmdAdmin
	public Object setConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		StringBuilder tmp = new StringBuilder("set tmp config...\n");
		for (Map.Entry<String, List<String>> e : request.getParameters().entrySet()) {
			String fieldName = e.getKey();
			String value = e.getValue().get(0);
			configProcessor.setFieldValue(fieldName, value, tmp);
		}
		String refererUrl = request.getHeader("Referer");// 获取发起请求地址的Url
		if (StringUtils.isNotBlank(refererUrl))
			response.redirect(refererUrl);
		return tmp.toString();
	}
}
