package com.xunlei.netty.httpserver.cmd.common;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dianping.cat.Cat;
import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.component.XLHttpResponse.ContentType;
import com.xunlei.netty.util.HtmlUtil;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;

/**
 * @author wangcanyi
 *
 */
@Service
public class HomeCmd extends BaseStatCmd {
    private static final Logger log = Log.getLogger();
	@Autowired
	private NettyServerConfig config;
	
    @CmdAdmin
    @CmdMapper("/")
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        init(request, response);
        response.setInnerContentType(ContentType.html);//HTML格式
        String tmp = "";
		List<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
		Map<String, String> mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "项目名");
		mapData.put("信息", Cat.getManager().getDomain());
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "服务器名");
		mapData.put("信息", Cat.getManager().getThreadLocalMessageTree().getHostName());
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "服务器IP");
		mapData.put("信息", Cat.getManager().getThreadLocalMessageTree().getIpAddress());
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "HTTP服务端口");
		mapData.put("信息", String.valueOf(config.getListen_port()));
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "SOA服务端口");
		mapData.put("信息", String.valueOf(config.getListen_soa_port()));
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "echo地址");
		mapData.put("信息", HtmlUtil.getHtmlLink("/echo"));
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "服务状态地址");
		mapData.put("地址", HtmlUtil.getHtmlLink("/stat"));
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "接口信息列表");
		mapData.put("信息", HtmlUtil.getHtmlLink("/setting/cmds"));
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "日志信息列表");
		mapData.put("信息", HtmlUtil.getHtmlLink("/logger/list"));
		tableData.add(mapData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "配置信息列表");
		mapData.put("信息", HtmlUtil.getHtmlLink("/setting/config"));
		tableData.add(mapData);
		tmp = HtmlUtil.getHtmlTable(tableData);
		mapData = new LinkedHashMap<String, String>();
		mapData.put("功能列表", "SAO API 服务列表");
		mapData.put("信息", HtmlUtil.getHtmlLink("/sOAServer/soaServiceAPIList"));
		tableData.add(mapData);
		tmp = HtmlUtil.getHtmlTable(tableData);
		return tmp;
    }
}
