/**
 * 
 */
package com.xunlei.netty.grpcserver.nameresolver;

import java.net.URI;

import com.google.common.base.Preconditions;
import com.xunlei.netty.soaserver.component.SOAServiceBase;

import io.grpc.Attributes;
import io.grpc.NameResolverProvider;
import io.grpc.internal.GrpcUtil;

/**
 * Consul 服务名 解析器 提供者
 * 
 * @author wangcanyi
 *
 */
public final class ConsulNameResolverProvider extends NameResolverProvider {
	private static final String SCHEME = "consul";
	private ConsulNameResolver consulNameResolver;
	private SOAServiceBase soaServiceBase;

	/**
	 * 构造器
	 * 
	 * @param soaServiceBase SOA服务基类
	 */
	public ConsulNameResolverProvider(SOAServiceBase soaServiceBase) {
		this.soaServiceBase = soaServiceBase;
	}

	@Override
	public ConsulNameResolver newNameResolver(URI targetUri, Attributes params) {
		if (SCHEME.equals(targetUri.getScheme())) {
			String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
			/*
			 * Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", targetPath, targetUri);
			 */
			String name = targetUri.getAuthority();
			consulNameResolver = new ConsulNameResolver(targetUri.getAuthority(), name, params, GrpcUtil.TIMER_SERVICE, GrpcUtil.SHARED_CHANNEL_EXECUTOR,
					this.soaServiceBase);
			return consulNameResolver;
		} else {
			return null;
		}
	}

	@Override
	public String getDefaultScheme() {
		return SCHEME;
	}

	@Override
	protected boolean isAvailable() {
		return true;
	}

	@Override
	protected int priority() {
		return 5;
	}

	/**
	 * @return the consulNameResolver
	 */
	public ConsulNameResolver getConsulNameResolver() {
		return consulNameResolver;
	}
}
