/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.env;

import com.google.common.collect.Maps;
import com.xunyi.env.AbstractEnvironment;
import com.xunyi.env.MapPropertySource;
import com.xunyi.env.MutablePropertySources;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class StandardEnvironment
extends AbstractEnvironment {
    @Override
    protected void customizePropertySources(MutablePropertySources propertySources) {
        InputStream applicationIn;
        InputStream in = this.getClass().getResourceAsStream("/env.properties");
        if (in != null) {
            this.load(propertySources, in);
        }
        if ((applicationIn = this.getClass().getResourceAsStream("/application.properties")) != null) {
            this.load(propertySources, applicationIn);
        }
        String env = this.getProperty("env");
        InputStream envIn = this.getClass().getResourceAsStream(String.format("/%s/application.properties", env));
        if (envIn != null) {
            this.load(propertySources, envIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(MutablePropertySources propertySources, InputStream in) {
        try {
            if (in != null) {
                Properties envProps = new Properties();
                envProps.load(in);
                HashMap properties = Maps.newHashMap();
                for (Object key : envProps.keySet()) {
                    String keyString = (String)key;
                    String value = envProps.getProperty(keyString);
                    properties.put(keyString, value);
                }
                MapPropertySource propertySource = new MapPropertySource("env", properties);
                propertySources.addLast(propertySource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

