/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import com.xunlei.netty.util.DateStringUtil;
import com.xunlei.netty.util.HttpUtil;
import com.xunlei.netty.util.HumanReadableUtil;
import com.xunlei.netty.util.StringTools;
import com.xunlei.netty.util.ValueUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SystemInfo {
    private static String serverStartupTime;
    public static final String LAUNCHER_NAME;
    public static final int PID;
    public static final String HOSTNAME;
    public static final String COMMAND_FULL;
    public static final String COMMAND;
    public static final String COMMAND_SHORT;

    private static String formatMemoryUsage(MemoryUsage mem) {
        String fmt = "\u521d\u59cb\u5316:%-10s \u5df2\u4f7f\u7528:%-10s \u6700\u5927:%-10s";
        return String.format(fmt, HumanReadableUtil.byteSize(mem.getInit()), HumanReadableUtil.byteSize(mem.getUsed()), HumanReadableUtil.byteSize(mem.getMax()));
    }

    private static String getContrastString(long before, long after) {
        long sub = after - before;
        if (sub > 0L) {
            return "\u2191" + HumanReadableUtil.byteSize(after);
        }
        if (sub < 0L) {
            return "\u2193" + HumanReadableUtil.byteSize(after);
        }
        return "";
    }

    public static StringBuilder getGarbageCollectorInfo(StringBuilder tmp) {
        List<java.lang.management.GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        tmp.append("GarbageCollectorMXBeans\n");
        String gcFmt = "%-23s %-8s %-20s %s\n";
        tmp.append(String.format(gcFmt, "GCName", "Count", "Time", "MemoryPoolNames"));
        LinkedHashSet<String> poolNames = new LinkedHashSet<String>();
        for (java.lang.management.GarbageCollectorMXBean gc : gcs) {
            tmp.append(String.format(gcFmt, gc.getName(), gc.getCollectionCount(), HumanReadableUtil.timeSpan(gc.getCollectionTime()), Arrays.toString(gc.getMemoryPoolNames())));
            for (String n : gc.getMemoryPoolNames()) {
                poolNames.add(n);
            }
        }
        gcFmt = "%-23s %-5s %-20s %-20s %s\n";
        long serverStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        tmp.append(String.format(gcFmt, "+ LastGcInfo", "Id", "StartTime", "EndTime", "Duration"));
        for (java.lang.management.GarbageCollectorMXBean gc : gcs) {
            GarbageCollectorMXBean g;
            GcInfo gi;
            if (!(gc instanceof GarbageCollectorMXBean) || (gi = (g = (GarbageCollectorMXBean)gc).getLastGcInfo()) == null || gi.getStartTime() == 0L) continue;
            DateStringUtil dsu = DateStringUtil.getInstance("HH:mm:ss.S");
            String start = dsu.format(new Date(serverStartTime + gi.getStartTime()));
            String end = dsu.format(new Date(serverStartTime + gi.getEndTime()));
            tmp.append(String.format(gcFmt, "  " + gc.getName(), gi.getId(), start, end, HumanReadableUtil.timeSpan(gi.getDuration())));
            Map<String, MemoryUsage> before = gi.getMemoryUsageBeforeGc();
            Map<String, MemoryUsage> after = gi.getMemoryUsageAfterGc();
            String muFmt = "%-23s %-30s %-14s %-14s %-14s %-14s\n";
            tmp.append(String.format(muFmt, "", "poolName", "init", "used", "committed", "max"));
            for (String name : poolNames) {
                MemoryUsage mu = before.get(name);
                MemoryUsage mu1 = after.get(name);
                if (mu == null) continue;
                tmp.append(String.format(muFmt, "", name, HumanReadableUtil.byteSize(mu.getInit()), HumanReadableUtil.byteSize(mu.getUsed()), HumanReadableUtil.byteSize(mu.getCommitted()), HumanReadableUtil.byteSize(mu.getMax())));
                String init = SystemInfo.getContrastString(mu.getInit(), mu1.getInit());
                String used = SystemInfo.getContrastString(mu.getUsed(), mu1.getUsed());
                String committted = SystemInfo.getContrastString(mu.getCommitted(), mu1.getCommitted());
                String max = SystemInfo.getContrastString(mu.getMax(), mu1.getMax());
                tmp.append(String.format(muFmt, "", "", init, used, committted, max));
            }
        }
        return tmp;
    }

    public static StringBuilder getMemoryInfo(StringBuilder tmp) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        tmp.append("\nmemoryMXBean\n");
        tmp.append("\u5df2\u4f7f\u7528\u5185\u5b58:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())).append("\n");
        tmp.append("\u5df2\u5206\u914d\u5185\u5b58:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().totalMemory())).append("\n");
        tmp.append("\u6700\u5927\u5185\u5b58:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().maxMemory())).append("\n");
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        tmp.append("\u5806\u5185\u5b58:\t\t\t").append(SystemInfo.formatMemoryUsage(memoryMXBean.getHeapMemoryUsage())).append("\n");
        tmp.append("\u975e\u5806\u5185\u5b58:\t\t").append(SystemInfo.formatMemoryUsage(memoryMXBean.getNonHeapMemoryUsage())).append("\n");
        tmp.append("\u5f85\u56de\u6536\u5bf9\u8c61\u6570:\t\t").append(memoryMXBean.getObjectPendingFinalizationCount()).append("\n");
        tmp.append("\n");
        return tmp;
    }

    public static String getServerStartupTime() {
        if (serverStartupTime == null) {
            serverStartupTime = DateStringUtil.DEFAULT.format(new Date(ManagementFactory.getRuntimeMXBean().getStartTime()));
        }
        return serverStartupTime;
    }

    static {
        String sunjavacommand = System.getProperty("sun.java.command");
        String command_full = "";
        String command_short = "";
        String command = "";
        if (StringTools.isNotEmpty(sunjavacommand)) {
            command_full = sunjavacommand;
            command = command_full.split(" ")[0];
            command_short = command.substring(command.lastIndexOf(46) + 1);
        }
        COMMAND_FULL = command_full;
        COMMAND = command;
        COMMAND_SHORT = command_short;
        String launcher_name = ManagementFactory.getRuntimeMXBean().getName();
        command_short = !"Launch".equals(command_short) && command_short.endsWith("Launch") ? command_short.substring(0, command_short.length() - "Launch".length()) : command_short;
        String hostName = "UNKNOWN";
        int pid = -1;
        String ip = HttpUtil.getLocalSampleIP();
        String pidAtHostName = ManagementFactory.getRuntimeMXBean().getName();
        int idx = pidAtHostName.indexOf(64);
        if (idx > 0) {
            pid = ValueUtil.getInteger(pidAtHostName.substring(0, idx), pid);
            hostName = pidAtHostName.substring(idx + 1);
        }
        String first = command_short;
        String second = ip.startsWith("192.168.") || ip.startsWith("10.10.") ? ip : hostName;
        launcher_name = first + "@" + second;
        PID = pid;
        HOSTNAME = hostName;
        LAUNCHER_NAME = launcher_name;
    }
}

