/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.xunlei.netty.cache.JRedisProxy;
import com.xunlei.util.Log;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class RedisLock2Util {
    private static Logger logger = Log.getLogger((String)RedisLock2Util.class.getName());
    private static final int DEFAULT_SINGLE_EXPIRE_TIME = 3;
    private static final int DEFAULT_RETRY_WATING_TIME = 300;
    private static final String STATUS_OK = "OK";

    public static String tryLock(String key) {
        return RedisLock2Util.tryLock(key, -1L);
    }

    public static String tryLock(String key, long connTimeout) {
        return RedisLock2Util.tryLock(key, connTimeout, TimeUnit.MILLISECONDS);
    }

    public static String tryLock(String key, long connTimeout, TimeUnit connTimeoutUnit) {
        return RedisLock2Util.tryLock(key, connTimeout, connTimeoutUnit, 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String tryLock(String key, long connTimeout, TimeUnit connTimeoutUnit, int keyTimeoutInSeconds) {
        if (key == null) {
            return null;
        }
        long originTime = System.currentTimeMillis();
        connTimeout = connTimeout > 0L ? connTimeoutUnit.toMillis(connTimeout) : connTimeout;
        try {
            do {
                String lockId;
                String code;
                if (RedisLock2Util.isSucc(code = RedisLock2Util.set(key, lockId = RedisLock2Util.getNextLockId(), keyTimeoutInSeconds))) {
                    return lockId;
                }
                if (connTimeout <= 0L) return null;
                Thread.sleep(300L);
            } while (System.currentTimeMillis() - originTime < connTimeout);
            return null;
        }
        catch (InterruptedException e) {
            logger.error("[RedisLockUtil.tryLock] key={},timeout={},unit={} Exception: ", new Object[]{key, connTimeout, connTimeoutUnit, e});
        }
        return null;
    }

    public static void unLock(String key, String lockId) {
        if (key == null || lockId == null) {
            return;
        }
        String currentLockId = JRedisProxy.getInstance().get(key);
        if (lockId.equals(currentLockId)) {
            JRedisProxy.getInstance().del(key);
        }
    }

    private static String getNextLockId() {
        return UUID.randomUUID().toString();
    }

    private static String set(String key, String lockId, int keyTimeoutInSeconds) {
        return JRedisProxy.getInstance().set(key, lockId, "NX", "EX", keyTimeoutInSeconds);
    }

    private static boolean isSucc(String code) {
        return STATUS_OK.equalsIgnoreCase(code);
    }
}

