/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.xunlei.netty.util.NetUtil;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.concurrent.NamedThreadFactory;
import com.xunlei.netty.util.spring.Config;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.springframework.stereotype.Service;

@Service
public final class NioSocketBootstrapFactory {
    private static final int DEFAULT_CONFIG_CONNECTTIMEOUTMILLIS = 5000;
    private static final int DEFAULT_CONFIG_RECEIVEBUFFERSIZE = 8192;
    private static final boolean DEFAULT_CONFIG_REUSEADDRESS = true;
    private static final int DEFAULT_CONFIG_SENDBUFFERSIZE = 8192;
    private static final int DEFAULT_CONFIG_SOLINGER = -1;
    private static final boolean DEFAULT_CONFIG_TCPKEEPALIVE = true;
    private static final boolean DEFAULT_CONFIG_TCPNODELAY = true;
    @Config
    private static int workerCount = NettyServerConfig.CORE_PROCESSOR_NUM;
    @Config
    private static int plCorePoolSize = NettyServerConfig.CORE_PROCESSOR_NUM * 50;
    @Config
    private static long plKeepAliveSecond = 60L;
    @Config
    private static long plMaxChannelMemorySize = 0x6400000L;
    @Config
    private static long plMaxTotalMemorySize = 0x40000000L;

    public static ExecutionHandler getExecutionHandler(String name, boolean ordered) {
        return ordered ? NioSocketBootstrapFactory.getExecutionHandlerOrdered(name) : NioSocketBootstrapFactory.getExecutionHandlerUnordered(name);
    }

    public static ExecutionHandler getExecutionHandlerUnordered(String name) {
        return new ExecutionHandler((Executor)new MemoryAwareThreadPoolExecutor(plCorePoolSize, plMaxChannelMemorySize, plMaxTotalMemorySize, plKeepAliveSecond, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("PIPELINE-" + name + "#", 7)));
    }

    public static ExecutionHandler getExecutionHandlerOrdered(String name) {
        return new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(plCorePoolSize, plMaxChannelMemorySize, plMaxTotalMemorySize, plKeepAliveSecond, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("PIPELINE-" + name + "#", 7)));
    }

    public static ClientBootstrap newClientBootstrap(ChannelPipelineFactory channelPipelineFactory, String name) {
        return NioSocketBootstrapFactory.newClientBootstrap(channelPipelineFactory, name, workerCount);
    }

    public static ClientBootstrap newClientBootstrap(ChannelPipelineFactory channelPipelineFactory, String name, int workerCount) {
        ExecutorService bossExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O client boss-" + name + "$", 10));
        ExecutorService workerExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O client worker-" + name + "$", 9));
        NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor, workerCount);
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)channelFactory);
        if (channelPipelineFactory != null) {
            bootstrap.setPipelineFactory(channelPipelineFactory);
        }
        NioSocketBootstrapFactory.setBootstrapOptions((Bootstrap)bootstrap);
        return bootstrap;
    }

    public static ServerBootstrap newServerBootstrap(ChannelPipelineFactory channelPipelineFactory, String name, int listen_port) {
        NetUtil.checkSocketPortBind(listen_port);
        ExecutorService bossExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server boss-" + name + "$", 10));
        ExecutorService workerExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server worker-" + name + "$", 9));
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor, workerCount);
        ServerBootstrap serverBootstrap = new ServerBootstrap((ChannelFactory)channelFactory);
        serverBootstrap.setPipelineFactory(channelPipelineFactory);
        NioSocketBootstrapFactory.setBootstrapOptions((Bootstrap)serverBootstrap);
        ChannelException ex = null;
        try {
            Channel channel = serverBootstrap.bind((SocketAddress)new InetSocketAddress(listen_port));
        }
        catch (ChannelException e) {
            ex = e;
        }
        String msg = ex == null ? "OK" : "ERROR";
        String chnmsg = ex == null ? "NioServerSocket-" + name + "\u670d\u52a1\u542f\u52a8\u5b8c\u6bd5.(port[" + listen_port + "])" : "NioServerSocket-" + name + "\u670d\u52a1\u542f\u52a8\u5931\u8d25.(port[" + listen_port + "])";
        String errStr = ex == null ? "" : ex.getMessage();
        NettyServerConfig.ALARMLOG.error("NioServerSocket-{}(port[{}],workerCount[{}]) Start {}.", new Object[]{name, listen_port, workerCount, msg, ex});
        System.err.println(chnmsg + errStr);
        if (ex != null) {
            System.exit(1);
        }
        return serverBootstrap;
    }

    public static void setBootstrapOptions(Bootstrap bootstrap) {
        NioSocketBootstrapFactory.setBootstrapOptions(bootstrap, 5000, 8192, 8192);
    }

    public static void setBootstrapOptions(Bootstrap bootstrap, int connectTimeoutMillis, int receiveBufferSize, int sendBufferSize) {
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("soLinger", (Object)-1);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.soLinger", (Object)-1);
        bootstrap.setOption("child.reuseAddress", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        bootstrap.setOption("connectTimeoutMillis", (Object)connectTimeoutMillis);
        bootstrap.setOption("receiveBufferSize", (Object)receiveBufferSize);
        bootstrap.setOption("sendBufferSize", (Object)sendBufferSize);
        bootstrap.setOption("child.keepAlive", (Object)true);
        bootstrap.setOption("child.connectTimeoutMillis", (Object)connectTimeoutMillis);
        bootstrap.setOption("child.receiveBufferSize", (Object)receiveBufferSize);
        bootstrap.setOption("child.sendBufferSize", (Object)sendBufferSize);
    }
}

