/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.xunlei.netty.util.EmptyChecker;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public class HttpUtil {
    private static Set<String> localIPSet;
    private static Set<String> localIPWith127001Set;
    private static String localSampleIP;

    public static String getIP(InetSocketAddress inetSocketAddress) {
        InetAddress addr;
        if (inetSocketAddress != null && (addr = inetSocketAddress.getAddress()) != null) {
            return addr.getHostAddress();
        }
        return "";
    }

    public static Set<String> getLocalIPWith127001() {
        if (localIPWith127001Set == null) {
            LinkedHashSet<String> localIPSetTmp = new LinkedHashSet<String>(3);
            try {
                Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
                while (e1.hasMoreElements()) {
                    NetworkInterface ni = e1.nextElement();
                    Enumeration<InetAddress> e2 = ni.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        InetAddress ia = e2.nextElement();
                        if (ia instanceof Inet6Address) continue;
                        String ip = ia.getHostAddress();
                        localIPSetTmp.add(ip);
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            localIPWith127001Set = localIPSetTmp;
        }
        return localIPWith127001Set;
    }

    public static Set<String> getLocalIP() {
        if (localIPSet == null) {
            LinkedHashSet<String> localIPSetTmp = new LinkedHashSet<String>(3);
            localIPSetTmp.addAll(HttpUtil.getLocalIPWith127001());
            localIPSetTmp.remove("127.0.0.1");
            localIPSet = localIPSetTmp;
        }
        return localIPSet;
    }

    public static String getLocalSampleIP() {
        if (localSampleIP == null) {
            Set<String> set = HttpUtil.getLocalIP();
            localSampleIP = EmptyChecker.isEmpty(set) ? "N/A" : set.iterator().next();
        }
        return localSampleIP;
    }

    public static Set<String> getIPByDomainName(String domainName) {
        LinkedHashSet<String> domainIPSet = new LinkedHashSet<String>(2);
        try {
            InetAddress[] inets;
            for (InetAddress inetAddress : inets = InetAddress.getAllByName(domainName)) {
                domainIPSet.add(inetAddress.getHostAddress());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainIPSet;
    }
}

