/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.component;

import com.xunlei.netty.util.Log;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class SOAServiceBase {
    private static final Logger log = Log.getLogger();
    private String appName;
    private String serviceHost;
    private int servicePort;
    private int connectionTimeout = 2000;
    private String signKey;
    private boolean consulIsEnable = false;
    private String grpcServiceHost;
    private int grpcServicePort;

    public SOAServiceBase(String appName, String configUrl) {
        this(appName, SOAServiceBase.getServiceClientProperties(configUrl));
    }

    public SOAServiceBase(String appName, Properties properties) {
        this.appName = appName;
        this.serviceHost = properties.getProperty("ServiceHost", "");
        this.servicePort = Integer.parseInt(properties.getProperty("ServicePort", "0"));
        this.connectionTimeout = Integer.parseInt(properties.getProperty("ConnectionTimeout", "2000"));
        this.signKey = properties.getProperty("SignKey", "");
        this.consulIsEnable = Boolean.parseBoolean(properties.getProperty("ConsulIsEnable", "false"));
        this.grpcServiceHost = properties.getProperty("GRPCServiceHost", "");
        this.grpcServicePort = Integer.parseInt(properties.getProperty("GRPCServicePort", "0"));
    }

    public SOAServiceBase(SOAServiceBase serviceBase) {
        this.appName = serviceBase.getAppName();
        this.serviceHost = serviceBase.getServiceHost();
        this.servicePort = serviceBase.getServicePort();
        this.connectionTimeout = serviceBase.getConnectionTimeout();
        this.signKey = serviceBase.getSignKey();
        this.consulIsEnable = serviceBase.isConsulIsEnable();
        this.grpcServiceHost = serviceBase.getGrpcServiceHost();
        this.grpcServicePort = serviceBase.getGrpcServicePort();
    }

    private static Properties getServiceClientProperties(String configUrl) {
        Properties config = new Properties();
        if (StringUtils.isNotBlank((String)configUrl)) {
            try {
                config.load(SOAServiceBase.class.getClassLoader().getResourceAsStream(configUrl));
                log.debug("\u83b7\u53d6\u670d\u52a1\u5ba2\u6237\u7aef\u914d\u7f6e[SOAServiceBase.getServiceClientProperties].\u6b63\u5e38\uff1aconfigUrl" + configUrl);
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u670d\u52a1\u5ba2\u6237\u7aef\u914d\u7f6e[SOAServiceBase.getServiceClientProperties].\u5f02\u5e38\uff1aconfigUrl" + configUrl, (Throwable)e);
            }
        }
        return config;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getServiceHost() {
        return this.serviceHost;
    }

    public void setServiceHost(String serviceHost) {
        this.serviceHost = serviceHost;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getSignKey() {
        return this.signKey;
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public boolean isConsulIsEnable() {
        return this.consulIsEnable;
    }

    public void setConsulIsEnable(boolean consulIsEnable) {
        this.consulIsEnable = consulIsEnable;
    }

    public String getGrpcServiceHost() {
        return this.grpcServiceHost;
    }

    public void setGrpcServiceHost(String grpcServiceHost) {
        this.grpcServiceHost = grpcServiceHost;
    }

    public int getGrpcServicePort() {
        return this.grpcServicePort;
    }

    public void setGrpcServicePort(int grpcServicePort) {
        this.grpcServicePort = grpcServicePort;
    }
}

