/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.component;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import com.google.gson.Gson;
import com.xunlei.netty.exception.BusinessRuntimeException;
import com.xunlei.netty.httpserver.handler.TextResponseHandlerManager;
import com.xunlei.netty.soaserver.cmd.BaseSOACmd;
import com.xunlei.netty.soaserver.cmd.CmdSOAMappers;
import com.xunlei.netty.soaserver.cmd.CmdSOAMeta;
import com.xunlei.netty.soaserver.component.BaseSOAPageDispatcher;
import com.xunlei.netty.soaserver.component.RpcInput;
import com.xunlei.netty.soaserver.component.RpcOutput;
import com.xunlei.netty.soaserver.exception.SOAServerRuntimeException;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CmdSOAMapperDispatcher
extends BaseSOAPageDispatcher {
    private static final Logger log = Log.getLogger();
    @Autowired
    private TextResponseHandlerManager handlerManager;
    @Autowired
    private CmdSOAMappers cmdSOAMappers;
    @Autowired
    private NettyServerConfig serverConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcInput _dispatch(RpcOutput rpcOutput) throws Exception {
        RpcInput rpcInput = rpcOutput.getRpcInput();
        Transaction t = Cat.newTransaction((String)"PigeonService", (String)rpcOutput.getSimpleName());
        t.addData("clientIp", (Object)rpcOutput.getIpAddress());
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        Cat.logEvent((String)"PigeonService.client", (String)rpcOutput.getIpAddress());
        Cat.logEvent((String)"PigeonService.app", (String)rpcOutput.getAppName());
        tree.setRootMessageId(rpcOutput.getRootMessageId());
        tree.setParentMessageId(rpcOutput.getMessageId());
        tree.setMessageId(rpcOutput.getChildMessageId());
        try {
            CmdSOAMeta soaMeta = this.cmdSOAMappers.getCmdSOAMeta(rpcOutput.getName());
            if (soaMeta == null) {
                throw new SOAServerRuntimeException("\u8d44\u6e90\u672a\u627e\u5230\uff1a" + rpcOutput.getInterfaceName() + "." + rpcOutput.getMethodName());
            }
            BaseSOACmd cmd = soaMeta.getCmd();
            Method method = soaMeta.getMethod();
            Object[] args = soaMeta.getMethodArgs(rpcOutput.getMethodObjectArgs(this.serverConfig.getServerSignKey()));
            Object resultObj = method.invoke((Object)cmd, args);
            rpcInput.setRetObj(resultObj);
            t.setStatus("0");
        }
        catch (IllegalAccessException e) {
            Exception ex = (Exception)e.getCause();
            if (ex != null) {
                rpcInput.setException(ex);
                if (ex instanceof BusinessRuntimeException) {
                    log.warn("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[BusinessRuntimeException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)ex);
                    t.setStatus("0");
                } else {
                    log.error("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[" + ex.getClass().getSimpleName() + "] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)ex);
                    t.setStatus((Throwable)ex);
                }
            } else {
                rpcInput.setException(e);
                t.setStatus((Throwable)e);
                log.error("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[IllegalAccessException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            Exception ex = (Exception)e.getCause();
            if (ex != null) {
                rpcInput.setException(ex);
                if (ex instanceof BusinessRuntimeException) {
                    log.warn("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[BusinessRuntimeException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)ex);
                    t.setStatus("0");
                } else {
                    log.error("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[" + ex.getClass().getSimpleName() + "] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)ex);
                    t.setStatus((Throwable)ex);
                }
            } else {
                rpcInput.setException(e);
                t.setStatus((Throwable)e);
                log.error("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[IllegalArgumentException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)e);
            }
        }
        catch (InvocationTargetException e) {
            Exception ex = (Exception)e.getCause();
            if (ex != null) {
                rpcInput.setException(ex);
                if (ex instanceof BusinessRuntimeException) {
                    log.warn("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[BusinessRuntimeException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)ex);
                    t.setStatus("0");
                } else {
                    log.error("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[" + ex.getClass().getSimpleName() + "] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)ex);
                    t.setStatus((Throwable)ex);
                }
            } else {
                rpcInput.setException(e);
                t.setStatus((Throwable)e);
                log.error("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[InvocationTargetException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)e);
            }
        }
        catch (SOAServerRuntimeException e) {
            rpcInput.setException(e);
            log.error("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[SOAServerRuntimeException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)e);
            t.setStatus((Throwable)e);
        }
        catch (Exception e) {
            rpcInput.setException(e);
            log.error("\u547d\u4ee4\u6620\u5c04\u5206\u53d1\u5904\u7406[Exception] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), (Throwable)e);
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
        return rpcInput;
    }

    @Override
    protected RpcInput dispatch(RpcOutput rpcOutput) throws Exception {
        Gson gson = new Gson();
        log.debug("Netty\u670d\u52a1.SOA\u8bf7\u6c42.rpcOutput:" + gson.toJson((Object)rpcOutput));
        RpcInput rpcInput = this._dispatch(rpcOutput);
        log.debug("Netty\u670d\u52a1.SOA\u8bf7\u6c42.\u8fd4\u56de\u503crpcInput:" + gson.toJson((Object)rpcInput));
        return rpcInput;
    }

    @Override
    public void init() throws Exception {
        log.debug("Netty\u670d\u52a1.\u521d\u59cb\u5316SOA\u63a5\u53e3.cmdSOAMappers.initInterfaceMap()");
        this.cmdSOAMappers.initInterfaceMap();
    }
}

