/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.cmd.common;

import com.xunlei.netty.soaserver.cmd.BaseSOACmd;
import com.xunlei.netty.soaserver.cmd.CmdSOAMappers;
import com.xunlei.netty.soaserver.cmd.CmdSOAMeta;
import com.xunlei.netty.soaserver.cmd.common.ISOACmdService;
import com.xunlei.netty.soaserver.cmd.common.args.SOACmdArg;
import com.xunlei.netty.soaserver.component.DTOBase;
import com.xunlei.netty.soaserver.component.RpcOutput;
import com.xunlei.netty.util.spring.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SOACmdServiceCmd
extends BaseSOACmd
implements ISOACmdService {
    @Autowired
    private CmdSOAMappers cmdSOAMappers;

    @Override
    public List<RpcOutput> findSOACmd(SOACmdArg arg) throws Exception {
        Map<String, CmdSOAMeta> allMeta;
        ArrayList<RpcOutput> result = new ArrayList<RpcOutput>();
        if (arg != null && (allMeta = this.cmdSOAMappers.getCmdAllMap()) != null && allMeta.size() > 0) {
            for (Map.Entry<String, CmdSOAMeta> metaMap : allMeta.entrySet()) {
                CmdSOAMeta meta = metaMap.getValue();
                if (StringUtils.isNotBlank((String)arg.getInterfaceName()) && !meta.getRpcObjectBase().getInterfaceName().equals(arg.getInterfaceName()) || arg.getIsAsynMethod() != null && !meta.getRpcObjectBase().getIsAsynMethod().equals(arg.getIsAsynMethod().toString()) || arg.getIsAdmin() != null && meta.getRpcObjectBase().isAdmin() != arg.getIsAdmin().booleanValue()) continue;
                RpcOutput rpcOutput = this.getRpcOutput(meta);
                result.add(rpcOutput);
            }
        }
        return result;
    }

    @Override
    public RpcOutput getSOACmd(String name) throws Exception {
        Map<String, CmdSOAMeta> allMeta;
        RpcOutput result = null;
        if (StringUtils.isNotBlank((String)name) && (allMeta = this.cmdSOAMappers.getCmdAllMap()) != null && allMeta.size() > 0) {
            for (Map.Entry<String, CmdSOAMeta> metaMap : allMeta.entrySet()) {
                String metaName = metaMap.getKey();
                CmdSOAMeta meta = metaMap.getValue();
                if (!metaName.equals(name)) continue;
                result = this.getRpcOutput(meta);
                break;
            }
        }
        return result;
    }

    private RpcOutput getRpcOutput(CmdSOAMeta meta) {
        RpcOutput result = null;
        if (meta != null) {
            result = new RpcOutput();
            BeanUtil.copyProperties(result, meta.getRpcObjectBase());
            Class<?>[] argTypes = meta.getMethod().getParameterTypes();
            if (argTypes != null && argTypes.length > 0) {
                DTOBase[] argDTO = new DTOBase[argTypes.length];
                for (int i = 0; i < argTypes.length; ++i) {
                    Class<?> argType = argTypes[i];
                    argDTO[i] = new DTOBase(null, argType);
                }
                result.setMethodArgs(argDTO);
            }
        }
        return result;
    }
}

