/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.cmd;

import com.xunlei.netty.soaserver.cmd.BaseSOACmd;
import com.xunlei.netty.soaserver.cmd.CmdSOAMeta;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAInterface;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.spring.BeanUtil;
import com.xunlei.netty.util.spring.SpringBootstrap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class CmdSOAMappers {
    private static final Logger log = Log.getLogger();
    private Map<String, CmdSOAMeta> cmdAllMap = new LinkedHashMap<String, CmdSOAMeta>();

    private BaseSOACmd getCmd(String name) {
        Object obj = BeanUtil.getTypedBean(name);
        if (obj instanceof BaseSOACmd) {
            Class<?> clazz = obj.getClass();
            if (clazz.getAnnotation(Deprecated.class) != null) {
                return null;
            }
            return (BaseSOACmd)obj;
        }
        return null;
    }

    private List<BaseSOACmd> getCmds() {
        ArrayList<BaseSOACmd> cmdList = new ArrayList<BaseSOACmd>();
        for (String name : SpringBootstrap.getContext().getBeanDefinitionNames()) {
            BaseSOACmd cmd = this.getCmd(name);
            if (cmd == null) continue;
            cmdList.add(cmd);
        }
        return cmdList;
    }

    public Map<String, CmdSOAMeta> initInterfaceMap() throws Exception {
        LinkedHashMap<String, CmdSOAMeta> tmpMeta = new LinkedHashMap<String, CmdSOAMeta>();
        for (BaseSOACmd cmd : this.getCmds()) {
            Class<?> clazz = cmd.getClass();
            Class<?>[] interfaceArray = clazz.getInterfaces();
            if (interfaceArray == null || interfaceArray.length <= 0) continue;
            for (Class<?> interfaceClass : interfaceArray) {
                Method[] interfaceMethodArray;
                if (interfaceClass.getAnnotation(CmdSOAInterface.class) == null || (interfaceMethodArray = interfaceClass.getMethods()) == null || interfaceMethodArray.length <= 0) continue;
                for (Method method : interfaceMethodArray) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    CmdSOAMeta soaMeta = new CmdSOAMeta(cmd, method, interfaceClass);
                    if (tmpMeta.containsKey(soaMeta.getRpcObjectBase().getName())) {
                        throw new Exception("Duplicate soa function:" + soaMeta.getRpcObjectBase().getName());
                    }
                    tmpMeta.put(soaMeta.getRpcObjectBase().getName(), soaMeta);
                }
            }
        }
        this.cmdAllMap.putAll(tmpMeta);
        log.debug("Netty\u670d\u52a1.SOA\u63a5\u53e3\u6620\u5c04.{}", tmpMeta);
        return this.cmdAllMap;
    }

    public CmdSOAMeta getCmdSOAMeta(String name) throws Exception {
        CmdSOAMeta meta = this.cmdAllMap.get(name);
        return meta;
    }

    public Map<String, CmdSOAMeta> getCmdAllMap() {
        return this.cmdAllMap;
    }
}

