/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.client;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import com.google.gson.Gson;
import com.xunlei.netty.exception.BusinessRuntimeException;
import com.xunlei.netty.soaserver.component.RpcInput;
import com.xunlei.netty.soaserver.component.RpcOutput;
import com.xunlei.netty.soaserver.component.SOAServiceBase;
import com.xunlei.netty.soaserver.exception.SOAServerRuntimeException;
import com.xunlei.netty.util.HttpUtil;
import com.xunlei.netty.util.Log;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class InterfaceProxyBase
implements InvocationHandler {
    private static final Logger log = Log.getLogger();
    private Class serviceInterface;
    private SOAServiceBase serviceBase;
    private Gson gson = new Gson();
    private final String charset_utf8 = "UTF-8";

    public InterfaceProxyBase(SOAServiceBase serviceBase, Class serviceInterface) {
        this.serviceBase = serviceBase;
        this.serviceInterface = serviceInterface;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("equals") || methodName.equals("hashCode") | methodName.equals("toString")) {
            Object[] newArgs = null;
            if (args != null && args.length > 0) {
                newArgs = new Object[args.length];
                for (int i = 0; i < args.length; ++i) {
                    Object object = args[i];
                    newArgs[i] = Proxy.isProxyClass(object.getClass()) ? object.getClass() : object;
                }
            }
            return method.invoke(proxy.getClass(), newArgs);
        }
        log.debug(String.format("Netty\u6846\u67b6.SOA.\u63a5\u53e3\u8c03\u7528[InterfaceProxyBase.invoke],proxy:%s,method:%s,args:%s", proxy.getClass().getName(), method.getName(), this.gson.toJson((Object)args)));
        RpcOutput rpcOutput = new RpcOutput();
        rpcOutput.setRpcObject(this.serviceInterface, method);
        rpcOutput.setMethodObjectArgs(args, this.serviceBase.getSignKey());
        return this.invoke(rpcOutput);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(RpcOutput rpcOutput) throws Exception {
        Object resultObj = null;
        log.debug(String.format("Netty\u6846\u67b6.SOA.\u63a5\u53e3\u8c03\u7528[InterfaceProxyBase.invoke],rpcOutput:%s", this.gson.toJson((Object)rpcOutput)));
        rpcOutput.setIpAddress(HttpUtil.getLocalSampleIP());
        rpcOutput.setAppName(Cat.getManager().getDomain());
        Transaction t = Cat.newTransaction((String)"PigeonCall", (String)rpcOutput.getSimpleName());
        try {
            RpcInput rpcInput = this.sendRequestRetry(rpcOutput);
            if (rpcInput != null) {
                if (!StringUtils.isNotBlank((String)rpcInput.getToken()) || !rpcInput.getToken().equals(rpcOutput.getToken())) throw new SOAServerRuntimeException("Token\u5339\u914d\u9519\u8bef\uff0cRpcOutput\uff1a" + rpcOutput.getName() + ";RpcInput\uff1a" + rpcInput.getName());
                if (rpcInput.getError() != null && rpcInput.getError().getException() != null) throw rpcInput.getError().getException();
                if (rpcInput.getIsSuccess().booleanValue()) {
                    resultObj = rpcInput.getRetObj();
                }
            }
            t.setStatus("0");
            return resultObj;
        }
        catch (BusinessRuntimeException e) {
            log.warn("Netty\u6846\u67b6.SOA\u5ba2\u6237\u7aef.\u8bf7\u6c42\u544a\u8b66.Code:" + e.getErrorCode() + "Msg:" + e.getMessage(), (Throwable)e);
            t.setStatus("0");
            throw e;
        }
        catch (SOAServerRuntimeException e) {
            log.error("Netty\u6846\u67b6.SOA\u5ba2\u6237\u7aef.\u8bf7\u6c42\u5f02\u5e38.Msg:" + e.getMessage(), (Throwable)e);
            t.setStatus((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Netty\u6846\u67b6.SOA\u5ba2\u6237\u7aef.\u8bf7\u6c42\u5f02\u5e38.Msg:" + e.getMessage(), (Throwable)e);
            t.setStatus((Throwable)e);
            throw e;
        }
        finally {
            t.complete();
        }
    }

    private RpcInput sendRequestRetry(RpcOutput rpcOutput) throws Exception {
        RpcInput rpcInput = null;
        int i = 0;
        while (i <= rpcOutput.getRetryCount()) {
            try {
                ++i;
                rpcInput = this.sendRequest(rpcOutput);
                break;
            }
            catch (Exception e) {
                log.error("Netty\u6846\u67b6.SOA.\u53d1\u9001\u8bf7\u6c42\u91cd\u8bd5[InterfaceProxyBase.sendRequestRetry].\u5f02\u5e38\uff1ai=" + i, (Throwable)e);
                if (i <= rpcOutput.getRetryCount()) continue;
                throw e;
            }
        }
        return rpcInput;
    }

    private RpcInput sendRequest(RpcOutput rpcOutput) throws Exception {
        RpcInput rpcInput = null;
        if (rpcOutput != null) {
            Socket socket = null;
            try {
                String serviceHost = this.serviceBase.getServiceHost();
                int servicePort = this.serviceBase.getServicePort();
                socket = new Socket(serviceHost, servicePort);
                if (this.serviceBase.getConnectionTimeout() > 0) {
                    socket.setSoTimeout(this.serviceBase.getConnectionTimeout());
                }
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                Cat.logEvent((String)"PigeonCall.server", (String)HttpUtil.getIP((InetSocketAddress)socket.getRemoteSocketAddress()));
                Cat.logEvent((String)"PigeonCall.app", (String)this.serviceBase.getAppName());
                Cat.logEvent((String)"PigeonCall.port", (String)String.valueOf(servicePort));
                String childId = Cat.createMessageId();
                Cat.logEvent((String)"RemoteCall", (String)"", (String)"0", (String)childId);
                rpcOutput.setRootMessageId(tree.getRootMessageId());
                rpcOutput.setMessageId(tree.getMessageId());
                rpcOutput.setChildMessageId(childId);
                OutputStream out = socket.getOutputStream();
                InputStream in = socket.getInputStream();
                String jsonObject = this.gson.toJson((Object)rpcOutput);
                out.write((jsonObject + "\r\n").getBytes("UTF-8"));
                if (rpcOutput.getIsAsynMethod().equals(Boolean.toString(false))) {
                    byte[] head = new byte[10];
                    in.read(head);
                    String strLength = new String(head);
                    int length = Integer.valueOf(strLength);
                    byte[] data = new byte[length];
                    int readLength = in.read(data);
                    while (readLength < length) {
                        byte[] dataFollow = new byte[length - readLength];
                        int dataFollowLength = in.read(dataFollow);
                        for (int i = 0; i < dataFollowLength; ++i) {
                            byte b;
                            data[readLength + i] = b = dataFollow[i];
                        }
                        log.debug("Netty\u6846\u67b6.SOA.\u53d1\u9001\u8bf7\u6c42[InterfaceProxyBase.sendRequest],length:" + length + ",readLength:" + (readLength += dataFollowLength) + ",dataFollowLength:" + dataFollowLength + ";dataFollowStr:" + new String(dataFollow, "UTF-8"));
                    }
                    String strData = new String(data, "UTF-8");
                    log.debug("Netty\u6846\u67b6.SOA.\u53d1\u9001\u8bf7\u6c42[InterfaceProxyBase.sendRequest],length:" + strLength + ";Data:" + strData);
                    if (StringUtils.isNotBlank((String)strData)) {
                        rpcInput = (RpcInput)this.gson.fromJson(strData, RpcInput.class);
                    }
                } else {
                    log.debug("Netty\u6846\u67b6.SOA.\u53d1\u9001\u8bf7\u6c42[InterfaceProxyBase.sendRequest],\u8be5\u65b9\u6cd5\u4e3a\u5f02\u6b65\u65b9\u6cd5\uff0c\u65e0\u9700\u7b49\u5f85\u63a5\u6536\u8fd4\u56de\u503c");
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (socket != null) {
                    socket.close();
                }
            }
        }
        return rpcInput;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }
}

