/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.handler;

import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.handler.Handler;
import com.xunlei.netty.httpserver.handler.TextResponseHandlerManager;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.Config;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class TextResponseHandler
implements Handler {
    public static final Logger log = Log.getLogger();
    @Autowired
    protected NettyServerConfig serverConfig;
    @Config
    protected String responseReturnNullInfo = "cmd return null";
    @Autowired
    protected TextResponseHandlerManager textResponseHandlerManager;
    @Config(resetable=true, split=",")
    protected Set<String> logThrowableIgnoreList = Collections.emptySet();

    public abstract String buildContentString(XLContextAttachment var1, Object var2);

    public abstract Object handleThrowable(XLContextAttachment var1, Throwable var2) throws Exception;

    public static void logError(String mailTitleInfo, String info, Object ... args) {
        Object objEx = args[args.length - 1];
        String exInfo = "";
        if (objEx instanceof Throwable) {
            exInfo = ((Throwable)objEx).getClass().getSimpleName();
        }
        MDC.put((String)"mailTitle", (String)(exInfo + ": " + mailTitleInfo));
        log.error(info, args);
    }

    public void logThrowable(XLContextAttachment attach, XLHttpRequest request, XLHttpResponse response, Throwable ex) {
        response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        if (this.logThrowableIgnoreList.contains(ex.getClass().getName())) {
            return;
        }
        TextResponseHandler.logError(request.getPath(), "{}:{} |{}\n\n{}", ex.getClass().getSimpleName(), request.getPath(), ManagementFactory.getRuntimeMXBean().getName(), request.getDetailInfo(), ex);
    }
}

