/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.xunlei.netty.cache.JRedisProxy;
import com.xunlei.netty.consul.ConsulFactory;
import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.soaserver.cmd.CmdSOAMappers;
import com.xunlei.netty.soaserver.cmd.CmdSOAMeta;
import com.xunlei.netty.util.HtmlUtil;
import com.xunlei.netty.util.HttpUtil;
import com.xunlei.netty.util.IPAuthenticator;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.Config;
import com.xunlei.netty.util.spring.ConfigBeanPostProcessor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SettingCmd
extends BaseStatCmd {
    private static final Logger log = Log.getLogger();
    @Autowired
    private CmdMappers cmdMappers;
    @Autowired
    private CmdSOAMappers cmdSOAMappers;
    @Autowired
    private NettyServerConfig config;
    @Autowired
    private ConfigBeanPostProcessor configProcessor;
    @Resource
    private HttpServerPipelineFactory httpServerPipelineFactory;

    @CmdMapper(value={"/robots.txt"})
    @CmdAdmin
    public Object robots(XLHttpRequest request, XLHttpResponse response) throws Exception {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        return "User-agent: *\nDisallow: /\n";
    }

    @CmdAdmin
    public Object cmds(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        boolean useTxt = request.getParameterBoolean("txt", false);
        if (!useTxt) {
            response.setInnerContentType(XLHttpResponse.ContentType.html);
        }
        String tmp = "";
        ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
        LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
        mapData.put("\u63a5\u53e3\u7c7b\u578b", "\u7ba1\u7406\u5458\u63a5\u53e3");
        mapData.put("\u5730\u5740", HtmlUtil.getHtmlLink("/setting/cmdsAdmain"));
        tableData.add(mapData);
        LinkedHashMap<String, String> mapData1 = new LinkedHashMap<String, String>();
        mapData1.put("\u63a5\u53e3\u7c7b\u578b", "HTTP\u63a5\u53e3");
        mapData1.put("\u5730\u5740", HtmlUtil.getHtmlLink("/setting/cmdsHTTP"));
        tableData.add(mapData1);
        LinkedHashMap<String, String> mapData2 = new LinkedHashMap<String, String>();
        mapData2.put("\u63a5\u53e3\u7c7b\u578b", "SOA\u63a5\u53e3");
        mapData2.put("\u5730\u5740", HtmlUtil.getHtmlLink("/setting/cmdsSOA"));
        tableData.add(mapData2);
        tmp = HtmlUtil.getHtmlTable(tableData);
        return tmp;
    }

    @CmdAdmin
    public Object cmdsAdmain(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        boolean useTxt = request.getParameterBoolean("txt", false);
        if (!useTxt) {
            response.setInnerContentType(XLHttpResponse.ContentType.html);
        }
        String tmp = "";
        Map<String, CmdMappers.CmdMeta> cmd_urls_map = this.cmdMappers.getCmdAllMap();
        if (cmd_urls_map != null && cmd_urls_map.size() > 0) {
            ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, CmdMappers.CmdMeta> cmdUrlMap : cmd_urls_map.entrySet()) {
                String cmdUrl = cmdUrlMap.getKey();
                CmdMappers.CmdMeta cmdMeta = cmdUrlMap.getValue();
                if (!cmdMeta.isAdmin()) continue;
                LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
                mapData.put("url", HtmlUtil.getHtmlLink(cmdUrl));
                mapData.put("name", cmdMeta.toString());
                mapData.put("isAdmin", String.valueOf(cmdMeta.isAdmin()));
                mapData.put("timeout", String.valueOf(cmdMeta.getTimeout()));
                tableData.add(mapData);
            }
            tmp = HtmlUtil.getHtmlTable(tableData);
        }
        return tmp;
    }

    @CmdAdmin
    public Object cmdsHTTP(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        boolean useTxt = request.getParameterBoolean("txt", false);
        if (!useTxt) {
            response.setInnerContentType(XLHttpResponse.ContentType.html);
        }
        String tmp = "";
        Map<String, CmdMappers.CmdMeta> cmd_urls_map = this.cmdMappers.getCmdAllMap();
        if (cmd_urls_map != null && cmd_urls_map.size() > 0) {
            ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, CmdMappers.CmdMeta> cmdUrlMap : cmd_urls_map.entrySet()) {
                String cmdUrl = cmdUrlMap.getKey();
                CmdMappers.CmdMeta cmdMeta = cmdUrlMap.getValue();
                if (cmdMeta.isAdmin()) continue;
                LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
                mapData.put("url", HtmlUtil.getHtmlLink(cmdUrl));
                mapData.put("name", cmdMeta.toString());
                mapData.put("isAdmin", String.valueOf(cmdMeta.isAdmin()));
                mapData.put("timeout", String.valueOf(cmdMeta.getTimeout()));
                tableData.add(mapData);
            }
            tmp = HtmlUtil.getHtmlTable(tableData);
        }
        return tmp;
    }

    @CmdAdmin
    public Object cmdsSOA(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        boolean useTxt = request.getParameterBoolean("txt", false);
        if (!useTxt) {
            response.setInnerContentType(XLHttpResponse.ContentType.html);
        }
        String tmp = "";
        Map<String, CmdSOAMeta> cmd_soa_map = this.cmdSOAMappers.getCmdAllMap();
        if (cmd_soa_map != null && cmd_soa_map.size() > 0) {
            ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, CmdSOAMeta> cmdUrlMap : cmd_soa_map.entrySet()) {
                String cmdSOA = cmdUrlMap.getKey();
                CmdSOAMeta cmdMeta = cmdUrlMap.getValue();
                LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
                mapData.put("SimpleName", cmdMeta.getRpcObjectBase().getSimpleName());
                mapData.put("IsAsynMethod", String.valueOf(cmdMeta.getRpcObjectBase().getIsAsynMethod()));
                tableData.add(mapData);
            }
            tmp = HtmlUtil.getHtmlTable(tableData);
        }
        return tmp;
    }

    @CmdAdmin
    public Object configHistory(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        return tmp.append((CharSequence)this.configProcessor.getResetHistory());
    }

    @CmdAdmin
    public Object config(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        response.setInnerContentType(XLHttpResponse.ContentType.html);
        ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
        String tmp = "";
        for (Field f : this.config.getClass().getDeclaredFields()) {
            Config fieldConfig;
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
            mapData.put("ConfigKey", f.getName());
            String configValueText = String.valueOf(f.get(this.config));
            if (f.getAnnotation(Config.class) != null && (fieldConfig = f.getAnnotation(Config.class)).resetable()) {
                String input = HtmlUtil.getInputText(f.getName(), String.valueOf(f.get(this.config)));
                configValueText = HtmlUtil.getHtmlForm(input, "/setting/setConfig");
            }
            mapData.put("ConfigValue", configValueText);
            tableData.add(mapData);
        }
        LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
        mapData.put("ConfigKey", "\u672c\u5730IP");
        mapData.put("ConfigValue", HttpUtil.getLocalIP() + "");
        tableData.add(mapData);
        mapData = new LinkedHashMap();
        mapData.put("ConfigKey", "IP\u767d\u540d\u5355");
        mapData.put("ConfigValue", IPAuthenticator.getIPWhiteList());
        tableData.add(mapData);
        if (JRedisProxy.getInstance() != null) {
            JRedisProxy jRedisProxy = JRedisProxy.getInstance();
            mapData = new LinkedHashMap();
            mapData.put("ConfigKey", "JRedis\u914d\u7f6e\u6587\u4ef6\u5730\u5740[JRedisProxy.jredisPropertiesUrl]");
            mapData.put("ConfigValue", jRedisProxy.getJredisPropertiesUrl());
            tableData.add(mapData);
            mapData = new LinkedHashMap();
            mapData.put("ConfigKey", "JRedis\u670d\u52a1\u5730\u5740[JRedisProxy.ServerHost]");
            mapData.put("ConfigValue", jRedisProxy.getServerHost());
            tableData.add(mapData);
            mapData = new LinkedHashMap();
            mapData.put("ConfigKey", "JRedis\u670d\u52a1\u7aef\u53e3[JRedisProxy.ServerPort]");
            mapData.put("ConfigValue", jRedisProxy.getServerPort() + "");
            tableData.add(mapData);
            mapData = new LinkedHashMap();
            mapData.put("ConfigKey", "JRedis\u670d\u52a1\u8d85\u65f6\u65f6\u95f4[JRedisProxy.ServerTimeout]");
            mapData.put("ConfigValue", jRedisProxy.getServerTimeout() + "");
            tableData.add(mapData);
            mapData = new LinkedHashMap();
            mapData.put("ConfigKey", "JRedis\u6700\u5927\u8fde\u63a5\u6570[JRedisProxy.MaxTotal]");
            mapData.put("ConfigValue", jRedisProxy.getMaxTotal() + "");
            tableData.add(mapData);
            mapData = new LinkedHashMap();
            mapData.put("ConfigKey", "JRedis\u6700\u5927\u7a7a\u95f2\u8fde\u63a5\u6570[JRedisProxy.MaxIdle]");
            mapData.put("ConfigValue", jRedisProxy.getMaxIdle() + "");
            tableData.add(mapData);
            mapData = new LinkedHashMap();
            mapData.put("ConfigKey", "JRedis\u83b7\u53d6\u8fde\u63a5\u65f6\u7684\u6700\u5927\u7b49\u5f85\u6beb\u79d2\u6570[JRedisProxy.MaxWaitMillis]");
            mapData.put("ConfigValue", jRedisProxy.getMaxWaitMillis() + "");
            tableData.add(mapData);
        }
        mapData = new LinkedHashMap();
        mapData.put("ConfigKey", "Consul.agentHost");
        mapData.put("ConfigValue", ConsulFactory.getInstance().getAgentHost());
        tableData.add(mapData);
        mapData = new LinkedHashMap();
        mapData.put("ConfigKey", "Consul.agentPort");
        mapData.put("ConfigValue", ConsulFactory.getInstance().getAgentPort() + "");
        tableData.add(mapData);
        tmp = HtmlUtil.getHtmlTable(tableData);
        return tmp;
    }

    @CmdAdmin
    public Object reloadConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        this.configProcessor.reloadConfig(tmp);
        return tmp.toString();
    }

    @CmdAdmin
    public Object reloadCmdConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        return null;
    }

    @CmdAdmin
    public Object reloadIpfilter(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        IPAuthenticator.reload();
        return "reset success";
    }

    @CmdAdmin
    public Object resetGuardedConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder("reset guarded config...\n");
        this.configProcessor.resetGuradedConfig(tmp);
        return tmp;
    }

    @CmdAdmin
    public Object setConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder("set tmp config...\n");
        for (Map.Entry<String, List<String>> e : request.getParameters().entrySet()) {
            String fieldName = e.getKey();
            String value = e.getValue().get(0);
            this.configProcessor.setFieldValue(fieldName, value, tmp);
        }
        String refererUrl = request.getHeader("Referer");
        if (StringUtils.isNotBlank((String)refererUrl)) {
            response.redirect(refererUrl);
        }
        return tmp.toString();
    }
}

