/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd;

import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.HTTPServerRuntimeException;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;

public abstract class BaseCmd {
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return null;
    }

    public void processBegin(XLHttpRequest request, XLHttpResponse response) throws Exception {
    }

    public void processEnd(XLHttpRequest request, XLHttpResponse response, Object resultObj) throws Exception {
    }

    protected <T> T getObjectByXLHttpRequest(Class<T> classType, XLHttpRequest request) throws Exception {
        T resultObject = null;
        if (classType == null) {
            new HTTPServerRuntimeException("classType\u4e3a\u7a7a");
        }
        if (request == null) {
            new HTTPServerRuntimeException("request\u4e3a\u7a7a");
        }
        resultObject = classType.newInstance();
        Field[] fieldArray = classType.getDeclaredFields();
        if (fieldArray != null && fieldArray.length > 0) {
            for (Field field : fieldArray) {
                field.setAccessible(true);
                String key = field.getName();
                String value = request.getParameter(key, "");
                if (!StringUtils.isNotBlank((String)value)) continue;
                this.setObjectField(field, resultObject, value);
            }
        }
        return resultObject;
    }

    private void setObjectField(Field field, Object resultObject, String value) throws Exception {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                field.setByte(resultObject, Byte.parseByte(value));
            }
            if (type == Short.TYPE) {
                field.setShort(resultObject, Short.parseShort(value));
            }
            if (type == Integer.TYPE) {
                field.setInt(resultObject, Integer.parseInt(value));
            }
            if (type == Long.TYPE) {
                field.setLong(resultObject, Long.parseLong(value));
            }
            if (type == Float.TYPE) {
                field.setFloat(resultObject, Float.parseFloat(value));
            }
            if (type == Double.TYPE) {
                field.setDouble(resultObject, Double.parseDouble(value));
            }
            if (type == Character.TYPE) {
                field.setChar(resultObject, value.charAt(0));
            }
            if (type == Boolean.TYPE) {
                field.setBoolean(resultObject, Boolean.parseBoolean(value));
            }
        } else {
            field.set(resultObject, value);
        }
    }
}

