/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.grpcserver.protobuf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;

public class GenerateProtoFile {
    private String packageName;
    private String filePath;
    private String serviceName;
    private boolean isCoverIfExist;
    private String protoHeaderFilePath = "com/xunlei/netty/grpcserver/protobuf/template/ProtoHeader.proto";
    private String protoMessageFilePath = "com/xunlei/netty/grpcserver/protobuf/template/ProtoMessage.proto";
    private String protoMessageFieldFilePath = "com/xunlei/netty/grpcserver/protobuf/template/ProtoMessageField.proto";
    private final String protoHeaderTmp;
    private final String protoMessageTmp;
    private final String protoMessageFieldTmp;

    public GenerateProtoFile(String filePath, String packageName, String serviceName) throws Exception {
        this(filePath, packageName, serviceName, false);
    }

    public GenerateProtoFile(String filePath, String packageName, String serviceName, boolean isCoverIfExist) throws Exception {
        if (StringUtils.isBlank((String)filePath)) {
            throw new RuntimeException("filePath\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)packageName)) {
            throw new RuntimeException("packageName\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)serviceName)) {
            throw new RuntimeException("serviceName\u4e3a\u7a7a");
        }
        this.filePath = filePath;
        this.packageName = packageName;
        this.serviceName = serviceName;
        this.isCoverIfExist = isCoverIfExist;
        this.protoHeaderTmp = this.readFile(this.protoHeaderFilePath);
        this.protoMessageTmp = this.readFile(this.protoMessageFilePath);
        this.protoMessageFieldTmp = this.readFile(this.protoMessageFieldFilePath);
    }

    public void generateProtoFileByDTO(Class ... classes) throws Exception {
        if (classes == null || classes.length == 0) {
            throw new RuntimeException("DTO\u5217\u8868\u4e3a\u7a7a");
        }
        StringBuilder protoFileSB = new StringBuilder(this.getProtoHeader());
        protoFileSB.append("\r\n\r\n");
        for (Class classDTO : classes) {
            String classMessage = this.getProtoMessage(classDTO);
            protoFileSB.append(classMessage);
            protoFileSB.append("\r\n\r\n");
        }
        this.writeFile(protoFileSB.toString());
    }

    private String getProtoHeader() throws Exception {
        String protoHeader = new String(this.protoHeaderTmp);
        if (StringUtils.isNotBlank((String)protoHeader)) {
            String packageName = this.packageName + ".proto";
            String javaPackageName = this.packageName + ".protobuf";
            String javaClassName = this.serviceName + "Proto";
            protoHeader = protoHeader.replace("{package}", packageName);
            protoHeader = protoHeader.replace("{java_package}", javaPackageName);
            protoHeader = protoHeader.replace("{java_outer_classname}", javaClassName);
        }
        return protoHeader;
    }

    private String getProtoMessage(Class classDTO) throws Exception {
        String protoMessage = new String(this.protoMessageTmp);
        StringBuilder protoMessageField = new StringBuilder();
        Field[] fields = classDTO.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String fieldType = this.getProtoFieldType(field.getType());
                String fieldName = field.getName();
                String messageField = new String(this.protoMessageFieldTmp);
                messageField = messageField.replace("{FieldType}", fieldType);
                messageField = messageField.replace("{FieldName}", fieldName);
                messageField = messageField.replace("{FieldIndex}", i + 1 + "");
                if (i != 0) {
                    protoMessageField.append("\r\n");
                }
                protoMessageField.append("\t");
                protoMessageField.append(messageField);
            }
        }
        protoMessage = protoMessage.replace("{MessageName}", classDTO.getSimpleName());
        protoMessage = protoMessage.replace("{MessageField}", protoMessageField.toString());
        return protoMessage;
    }

    private String getProtoFieldType(Class<?> type) {
        if (type != null) {
            if (type == Double.TYPE || type == Double.class) {
                return "double";
            }
            if (type == Float.TYPE || type == Float.class) {
                return "float";
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return "int32";
            }
            if (type == Long.TYPE || type == Long.class) {
                return "int64";
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return "bool";
            }
            if (type == String.class) {
                return "string";
            }
        }
        return "UnKnown";
    }

    private String readFile(String filePath) throws Exception {
        InputStream fis = GenerateProtoFile.class.getClassLoader().getResourceAsStream(filePath);
        byte[] buf = new byte[1024];
        StringBuffer sb = new StringBuffer();
        while (fis.read(buf) != -1) {
            sb.append(new String(buf, "UTF8"));
            buf = new byte[1024];
        }
        fis.close();
        return sb.toString().trim();
    }

    private void writeFile(String content) throws Exception {
        File file = new File(this.filePath);
        if (file.isDirectory()) {
            throw new FileNotFoundException();
        }
        if (!file.exists()) {
            file.createNewFile();
        } else if (!this.isCoverIfExist) {
            throw new RuntimeException("\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u66ff\u6362");
        }
        FileOutputStream out = new FileOutputStream(file, false);
        BufferedWriter rd = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "utf-8"));
        rd.write(content);
        rd.close();
        out.close();
    }
}

