/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.model.HealthService;
import com.xunlei.netty.consul.loadbalance.ILoadBalance;
import com.xunlei.netty.consul.loadbalance.RoundRobinLoadBalance;
import com.xunlei.netty.consul.service.ServiceClient;
import com.xunlei.netty.util.Log;
import com.xunlei.niux.common.util.IPUtil;
import com.xunyi.ApplicationHelper;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class ConsulFactory {
    private static final Logger log = Log.getLogger();
    public static Env CONSUL_ENV = ConsulFactory.getEnv();
    private static ConsulFactory consulFactory;
    private static ConsulFactory consulFactoryTest;
    private static ConsulFactory consulFactoryPreRelease;
    private String agentHost;
    private int agentPort;
    private ConsulClient consulClient;
    private ServiceClient serviceClient;
    private ILoadBalance loadBalance;

    public static ConsulFactory getInstance() {
        return ConsulFactory.getInstance(CONSUL_ENV);
    }

    public static ConsulFactory getInstance(Env env) {
        if (env == Env.Test) {
            if (consulFactoryTest == null) {
                consulFactoryTest = new ConsulFactory(env);
            }
            return consulFactoryTest;
        }
        if (env == Env.PreRelease) {
            if (consulFactoryPreRelease == null) {
                consulFactoryPreRelease = new ConsulFactory(env);
            }
            return consulFactoryPreRelease;
        }
        if (env == Env.Release) {
            if (consulFactory == null) {
                consulFactory = new ConsulFactory(env);
            }
            return consulFactory;
        }
        return null;
    }

    protected static String getProxyTestUrl() {
        return "/proxyTesting";
    }

    protected static String getPreReleaseHostName() {
        return "twin14543vm10,twin14543vm11";
    }

    private static Env getEnv() {
        InputStream is = ConsulFactory.class.getResourceAsStream(ConsulFactory.getProxyTestUrl());
        if (is != null) {
            String info = "ConsulFactory Default Mode: TESTING";
            log.error(info);
            System.err.println(info);
            return Env.Test;
        }
        String localHostName = IPUtil.getLocalHostName();
        if (StringUtils.isNotBlank((String)localHostName)) {
            if (ConsulFactory.getPreReleaseHostName().contains(localHostName)) {
                String info = "ConsulFactory Default Mode: Pre-RELEASE\nIf you want to use testing mode:put an empty file named 'proxyTesting' in your classpath";
                log.error(info);
                System.err.println(info);
                return Env.PreRelease;
            }
            String info = "ConsulFactory Default Mode: RELEASE\nIf you want to use testing mode:put an empty file named 'proxyTesting' in your classpath";
            log.error(info);
            System.err.println(info);
            return Env.Release;
        }
        return Env.Test;
    }

    private ConsulFactory(Env env) {
        try {
            this.agentHost = ApplicationHelper.environment.getProperty("consul.agentHost", "consul.niu.xunlei.com");
            this.agentPort = ApplicationHelper.environment.getProperty("consul.agentPort", Integer.class, 8500);
            ConsulRawClient consulRawClient = new ConsulRawClient(this.agentHost, this.agentPort);
            this.consulClient = new ConsulClient(consulRawClient);
        }
        catch (Exception e) {
            System.out.println("ConsulFactory \u521b\u5efa\u5931\u8d25");
            e.printStackTrace();
            log.error("ConsulFactory\u521b\u5efa[ConsulFactory(Env env)].\u5f02\u5e38", (Throwable)e);
        }
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public ConsulClient getConsulClient() {
        return this.consulClient;
    }

    public ServiceClient getServiceClient() {
        if (this.serviceClient == null) {
            this.serviceClient = new ServiceClient();
        }
        return this.serviceClient;
    }

    public ILoadBalance getLoadBalance() {
        if (this.loadBalance == null) {
            this.loadBalance = new RoundRobinLoadBalance();
        }
        return this.loadBalance;
    }

    public List<HealthService> getServiceList(String serviceName) {
        return this.getServiceClient().getServiceList(serviceName);
    }

    public NewService registerService(String serviceName, int httpPort, int soaPort) throws Exception {
        return this.getServiceClient().registerService(serviceName, httpPort, soaPort);
    }

    public HealthService choose(String serviceName) {
        return this.getLoadBalance().choose(serviceName);
    }

    public static enum Env {
        Test,
        Release,
        PreRelease;

    }
}

