/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.xunlei.netty.cache.JRedisProxy;
import com.xunlei.util.Log;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class RedisLockUtil {
    private static Logger logger = Log.getLogger((String)RedisLockUtil.class.getName());
    private static final long DEFAULT_SINGLE_EXPIRE_TIME = 3000L;
    private static final int DEFAULT_RETRY_WATING_TIME = 300;
    private static final int RETRY_COUNT = 5;

    public static boolean tryLock(String key) {
        return RedisLockUtil.tryLock(key, -1L);
    }

    public static boolean tryLock(String key, long connTimeout) {
        return RedisLockUtil.tryLock(key, connTimeout, TimeUnit.MILLISECONDS);
    }

    public static boolean tryLock(String key, long connTimeout, TimeUnit connTimeoutUnit) {
        return RedisLockUtil.tryLock(key, connTimeout, connTimeoutUnit, 3000L, TimeUnit.MILLISECONDS);
    }

    public static boolean tryLock(String key, long connTimeout, TimeUnit connTimeoutUnit, long keyTimeout, TimeUnit keyTimeoutUnit) {
        if (key == null) {
            return false;
        }
        boolean result = false;
        long originTime = System.currentTimeMillis();
        connTimeout = connTimeout > 0L ? connTimeoutUnit.toMillis(connTimeout) : connTimeout;
        keyTimeout = keyTimeoutUnit.toMillis(keyTimeout);
        try {
            while (!(result = RedisLockUtil.getLock(key, keyTimeout)) && connTimeout > 0L) {
                Thread.sleep(300L);
                if (System.currentTimeMillis() - originTime < connTimeout) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            logger.error("[RedisLockUtil.tryLock] key={},timeout={},unit={} Exception: ", new Object[]{key, connTimeout, connTimeoutUnit, e});
        }
        return result;
    }

    private static boolean getLock(String key, long keyTimeout) {
        Boolean result = null;
        JRedisProxy proxy = JRedisProxy.getInstance();
        for (int i = 0; i < 5 && (result = proxy.setnx(key, String.valueOf(System.currentTimeMillis() + keyTimeout))) == null; ++i) {
        }
        if (result == null) {
            return false;
        }
        if (result.booleanValue()) {
            return true;
        }
        String oldExpiredTimeStr = proxy.get(key);
        if (oldExpiredTimeStr != null) {
            long currentExpiredTime;
            long oldExpiredTime = Long.parseLong(oldExpiredTimeStr);
            long now = System.currentTimeMillis();
            if (now >= oldExpiredTime && (currentExpiredTime = Long.parseLong(proxy.getSet(key, String.valueOf(now + keyTimeout)))) == oldExpiredTime) {
                return true;
            }
        }
        return false;
    }

    public static void unLock(String key) {
        if (key == null) {
            return;
        }
        JRedisProxy.getInstance().del(key);
    }
}

